#include "deds/vector.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>

void mx__vector_remove(MX__VECTOR_DATA * vect, const size_t dindex, size_t num, const size_t sizeofdata)
{
	assert(vect);
	assert(sizeofdata);

	if (dindex < vect->_size) {
		size_t bytes;
		unsigned char *begin = (unsigned char *) vect->_data + dindex * sizeofdata;

		if ((dindex + num) > vect->_size)
			num = vect->_size - dindex;

		bytes = (vect->_size - dindex - num) * sizeofdata;

		if (bytes)
			memmove(begin, begin + num * sizeofdata, bytes);

		vect->_size -= num;
	}
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
