#include "deds/string.h"
#include <assert.h>

/** !Set MX_STRING text and length
This function sets the text, length and free function of a MX_STRING
object.  When mx_string_free() is called the free function will be called to
release the memory associated with the text.  The free parameter may be 0 in
which case no function will be called to release the text memory. */
void mx_string_set(MX_STRING * string, const char *text, int len, const MX_FREE dfree)
{
	assert(string);

	if ((string->_text) && (string->_free))
		string->_free((void *) string->_text);

	string->_text = text;

	/** If the len parameter is less than 0 (usually -1) then the string
	is assumed to be zero terminated. */
	string->_len = len;
	string->_free = dfree;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
