#include "deds/string.h"
#include <assert.h>
#include <string.h>

/** !Reallocate a MX_STRING
This function changes the memory allocation of the text inside a
MX_STRING to the ones in the argumnets.  Memory is allocated using the alloc
function and the current contents of the string is copied to the newly
allocated memory.  The free function will be called when the memory
associated with the text needs to be freed. */
void mx_string_realloc(MX_STRING * string, const MX_ALLOC alloc, const MX_FREE dfree)
{
	char *text = 0;
	int len = string->_len;

	assert(string);

	if ((len < 0) && (string->_text))
		len = strlen(string->_text) + 1;

	if (alloc)
		text = alloc((unsigned) len);

	if (text) {
		memcpy(text, string->_text, (unsigned) len);

		if (string->_free)
			string->_free((void *) string->_text);

		string->_text = text;
	}
	string->_free = dfree;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
