/** !Some simple string allocation and handling functions.

This module contains functions for object-oriented handling of
const char* strings in C.  Strings can be either zero-terminated or have some 
fixed length.  The contents of the string cannot be (easily) changed.
<p>
MX_STRING is bit-copy-correct which means that a binary copy retains
proper functioning and takes over ownership of internal buffers.  The copy
source MX_STRING should not be used once the copy takes place.
<p>
Memory containing a MX_STRING can be realloc'd without affecting proper
operation.  Therefore it can be used inside a MX_VECTOR. */

#ifndef MX__DEDS_STRING_HEADER
#define MX__DEDS_STRING_HEADER

#include "deds/memtype.h"

#ifdef __cplusplus
extern "C" {
#endif

/** !A string object */
    typedef struct MX_STRING {
	const char *_text;
	int _len;
	MX_FREE _free;
    } MX_STRING;

    void mx_string(MX_STRING * string);
    void mx_string_free(MX_STRING * string);

    void mx_string_set(MX_STRING * string, const char *text, int len,
		       const MX_FREE dfree);

    void mx_string_realloc(MX_STRING * string, const MX_ALLOC alloc,
			   const MX_FREE dfree);

    const char *mx_string_text(const MX_STRING * string, int *len);
    int mx_string_len(const MX_STRING * string);

#ifdef __cplusplus
}
#endif
#endif
/*
    DEDS
    Data structures and utility functions for C
    Copyright (C) 2006 Douglas Eleveld

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
