#define MXMODULE_ATOM
#define MXMODULE_RECT

#include "deds/rectatom.h"
#include <assert.h>

/** !Construct a MX_RECTATOM. */
void *mx__rectatom(MX_RECTATOM_DATA * rectatom, MX__ATOM_DESTRUCT destruct, size_t size)
{
	void *ret;

	if (size < sizeof(MX_RECTATOM))
		size = sizeof(MX_RECTATOM);

	ret = mx_atom(rectatom, destruct, size);

	assert(ret);
	MXDEBUG_ALLOCTAG(ret);

	return ret;
}

/** !Place a MX_RECTATOM
This function places a MX_RECTATOM at a specified area. */
void mx__rectatom_place(MX_RECTATOM_DATA * rectatom, const MX_RECT * rrect)
{
	rectatom->_rect = *rrect;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
