/** !Basic rectangle handling

This module contains typedefs, functions and macros for handling
rectangles.  Also included are macros to determine intersections and unions
areas. */

#ifndef MX__DEDS_RECT_HEADER
#   define MX__DEDS_RECT_HEADER

#   ifdef __cplusplus
extern "C" {
#   endif
/** !A basic rectangle
This type is a basic rectangle with an upper-left at x1,y1 and 
lower-right at x2, y2. */ typedef struct MX_RECT {
		int x1;	/** Left coordinate */
		int y1;	/** Upper coordinate */
		int x2;	/** Right coordinate */
		int y2;	/** Lower coordinate */
	} MX_RECT;

	void mx_rect_move(MX_RECT * rect, int x, int y);
	void mx_rect_resize(MX_RECT * rect, int w, int h);

/** !Is MX_RECT valid?
This macro returns non-zero if the upper-left of the rectangle is 
above and to the right of the lower-left of the rectangle, zero otherwise. */
#   define MXRECT_VALID(A)  \
   (((A).x2 >= (A).x1)&& \
    ((A).y2 >= (A).y1))

/** !Find intersection of two rectangles
This macro finds the intersection of two rectangles. */
#   define MXRECT_INTERSECT(A, B, R)      \
   do {                                \
       (R).x1 = MX_MAX((A).x1, (B).x1); \
       (R).y1 = MX_MAX((A).y1, (B).y1); \
       (R).x2 = MX_MIN((A).x2, (B).x2); \
       (R).y2 = MX_MIN((A).y2, (B).y2); \
   } while (0)

/** !Union of two rectangles. */
#   define MXRECT_UNION(A, B, R)          \
   do {                                \
       (R).x1 = MX_MIN((A).x1, (B).x1); \
       (R).y1 = MX_MIN((A).y1, (B).y1); \
       (R).x2 = MX_MAX((A).x2, (B).x2); \
       (R).y2 = MX_MAX((A).y2, (B).y2); \
   } while (0)

/** !Point contained in MX_RECT
This macro return non-zero if a given x,y point is indose the 
rectangel error, zero otherwise. */
#   define MXRECT_CONTAINS(R, X, Y) \
   ((X >= (R).x1) &&             \
    (X <= (R).x2) &&             \
    (Y >= (R).y1) &&             \
    (Y <= (R).y2))

/** !Do MX_RECT overlap?
This macro return non-zero if two rectangels overlap, zero otherwise. */
#   define MXRECTS_OVERLAP(A, B) \
   (!(((B).x1 > (A).x2) ||    \
      ((B).y1 > (A).y2) ||    \
      ((B).x2 < (A).x1) ||    \
      ((B).y2 < (A).y1)))

#   define MX__TOP_RECTS(A, B, R)        \
   (R).x1 = (A).x1;                   \
   (R).y1 = (A).y1;                   \
   (R).x2 = (A).x2;                   \
   (R).y2 = MX_MIN( (B).y1-1, (A).y2 )

#   define MX__LEFT_RECTS(A, B, R)        \
   (R).x1 = (A).x1;                    \
   (R).y1 = MX_MAX( (B).y1, (A).y1 );   \
   (R).x2 = MX_MIN( (B).x1-1, (A).x2 ); \
   (R).y2 = MX_MIN( (B).y2, (A).y2 )

#   define MX__RIGHT_RECTS(A, B, R)       \
   (R).x1 = MX_MAX( (B).x2+1, (A).x1 ); \
   (R).y1 = MX_MAX( (B).y1, (A).y1 );   \
   (R).x2 = (A).x2;                    \
   (R).y2 = MX_MIN( (B).y2, (A).y2 )

#   define MX__BOT_RECTS(A, B, R)         \
   (R).x1 = (A).x1;                    \
   (R).y1 = MX_MAX( (B).y2+1, (A).y1 ); \
   (R).x2 = (A).x2;                    \
   (R).y2 = (A).y2

#   ifdef __cplusplus
}
#   endif
#endif
/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
