#include "deds/rect.h"

/** !Move a MX_RECT
This function moves a MX_REXT so that the upper left of the rectangle 
is at a given x,y, position.  The size of the rectangle is not changed. */
void mx_rect_move(MX_RECT * rrect, int x, int y)
{
	const int w = rrect->x2 - rrect->x1;
	const int h = rrect->y2 - rrect->y1;

	rrect->x1 = x;
	rrect->y1 = y;
	rrect->x2 = x + w;
	rrect->y2 = y + h;
}

/** !Resize a MX_RECT
This function resizes a MX_REXT to a given size.  The upper left point 
of the rectangle does not change.  */
void mx_rect_resize(MX_RECT * rrect, int w, int h)
{
	rrect->x2 = rrect->x1 + w;
	rrect->y2 = rrect->y1 + h;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
