/** !Typedefs for memory managment functions.

This module contains typedefs for memory allocation functions similar
to the stdlib malloc/realloc/free functions. */

#ifndef MX__DEDS_MEMTYPE_HEADER
#   define MX__DEDS_MEMTYPE_HEADER

#   include <stdlib.h>

#   ifdef __cplusplus
extern "C" {
#   endif
/** !A stdlib malloc-like function. */ typedef void *(*MX_ALLOC) (size_t bytes);

/** !A stdlib realloc-like function. */
	typedef void *(*MX_REALLOC) (void *ptr, size_t bytes);

/** !A stdlib free-like function. */
	typedef void (*MX_FREE) (void *ptr);

	typedef struct MX_ALLOCATOR_DATA {
		MX_ALLOC alloc;
		MX_REALLOC realloc;
		MX_FREE free;
	} MX_ALLOCATOR_DATA;

/** !A standard memory alloc/realloc/free tool */
	typedef struct MX_ALLOCATOR {
		union {
			MX_ALLOCATOR_DATA alloc;
		} base;
	} MX_ALLOCATOR;

	extern MX_ALLOCATOR mx_stdalloc;

#   ifdef __cplusplus
}
#   endif
#endif
/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
