/**license
    DEDS<br>
    Data structures and utility functions for C<br>
    Copyright (C) 2006 Douglas Eleveld<br>

    <p>This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    <p>This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    <p>You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**author <a href="deds.htm">DEDS</a> written by Doug Eleveld (deleveld@dds.nl) */

#ifndef MX__DEDS_HEADER
#define MX__DEDS_HEADER

#define MX_DEDS_VERSION 1
#define MX_DEDS_SUBVERSION 2

#ifdef NDEBUG
#ifdef MXDEBUG
#undef MXDEBUG
#endif
#endif

#include "deds/atom.h"
#include "deds/alloc.h"
#include "deds/bool.h"
#include "deds/dllist.h"
#include "deds/tree.h"
#include "deds/maxmin.h"
/*#include "deds/memtype.h"*/
#include "deds/string.h"
#include "deds/vector.h"
#include "deds/rect.h"
#include "deds/rectatom.h"

#endif

/**library !Data structures and utility functions for C

This library contains various generic data structures and utility functions.

DEDS is used by <a href="degfx.htm">DEGFX</a> portable graphics library and
<a href="depui.htm">DEPUI</a> portable gui library.
*/
