/** !Some simple file oriented functions

This module contains some simple file oriented functions primarily
intended to be useful for GUI development. */

#ifndef MX__DETK_FILE_HEADER
#define MX__DETK_FILE_HEADER

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

	void mx_path_fix(char *ptr);

	unsigned mx_filename_match(const char *p, const char *t);

	const char *mx_basename(const char *fname);

	int mx_fgetw(FILE * f);

#ifdef MXMODULE_DIRENT

/**author Implementation of POSIX directory browsing functions and types for Win32.<br>
    Author:  Kevlin Henney (kevlin@acm.org, kevlin@curbralan.com)<br>
    History: Created March 1997. Updated February 2003.<br>
    Copyright Kevlin Henney, 1997, 2003. All rights reserved.<br>

<p>Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose is hereby granted without fee, provided
   that this copyright and permissions notice appear in all copies and
   derivatives.

<p>This software is supplied "as is" without express or implied warranty.

<p>But that said, if there are any problems please get in touch. */

struct dirent {
	 char *d_name;
};

#include <errno.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

typedef struct DIR {
	 long handle;					  /* -1 for failed rewind */
	 struct _finddata_t info;
	 struct dirent result;		  /* d_name null iff first time */
	 char *name;					  /* null-terminated char string */
} DIR;

        DIR *opendir(const char *name);
        int closedir(DIR * dir);
        struct dirent *readdir(DIR * dir);
        void rewinddir(DIR * dir);

#endif

#ifdef __cplusplus
}
#endif
#endif
