/** !Dirty rectangle updating system
This module implements a dirty-rectangle updating system. */

#ifndef MX__DETK_DRS_HEADER
#   define MX__DETK_DRS_HEADER

#   include "deds/rect.h"

#   ifdef __cplusplus
extern "C" {
#   endif
/** !Flush callback function for dirty rectangle updating
This typedef defines a user defined callback function where dirty
portions of the screen are determined.  Inside the callback the user should
place code to actually update the screen area.  The updating rectangle can be
modified by the callback to indicate what portions of the screen are actually
updated.  */ typedef void (*MX_FLUSH_FUNC) (MX_RECT * rect);

	void mx_drs_area(int w, int h);

	void mx_drs_dirty(const MX_RECT * rect, unsigned mark);

	unsigned mx_drs_update(MX_FLUSH_FUNC flush);

	unsigned mx_drs_dirtychanged(void);

#   ifdef __cplusplus
}
#   endif
#endif
