/** !A theme selector and loader
This module implements a theme selector dialog. */

#ifndef MX_DEPUI_THEMESEL_HEADER
#   define MX_DEPUI_THEMESEL_HEADER

#   include "depui/depui.h"
#   include <assert.h>

#   ifdef __cplusplus
extern "C" {
#   endif
/** !A theme seletion window */ 
typedef struct MX_THEMESEL {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;

		MX_LIST _themes;
		MX_BUTTON _apply;
		MX_BUTTON _ok;
		const MX_THEME *_chosen;
	} MX_THEMESEL;

	void mx_themesel_handler(MX_WIN * win);
	MX_THEMESEL *mx_themeselwin(MX_THEMESEL * sel, size_t size, MX_HANDLER handler, int id);

/** !Create a theme selector window
This macro creates a theme selector with the specified id number. */
#   define mx_themesel(id) mx_themeselwin(0, 0, 0, (id))

	void mx_themesel_refresh(MX_THEMESEL * fsel);

	const MX_THEME *mx_themesel_info(const int idnum);

#   ifdef __cplusplus
}
#   endif
#endif
