/** !A text editor */

#ifndef MX_DEPUI_TEXTEDIT_HEADER
#   define MX_DEPUI_TEXTEDIT_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
/** !Text editor */ typedef struct MX_TEXTEDITOR {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		char message[100];
		MX_BUTTON open;
		MX_BUTTON save;
		MX_SCROLL scroll;
		MX_EDITTEXT edit;
	} MX_TEXTEDITOR;

	void mx_texteditor_handler(MX_WIN * win);
	MX_TEXTEDITOR *mx_texteditorwin(MX_TEXTEDITOR * e, size_t size, MX_HANDLER handler, int theid);

/** !Create a text editor window. */
#   define mx_texteditor(id) mx_texteditorwin(0, 0, 0, (id))

	void mx_texteditor_save(const MX_TEXTEDITOR * e, const char *path);
	void mx_texteditor_open(MX_TEXTEDITOR * e, const char *path);

#   ifdef __cplusplus
}
#   endif
#endif
