/** !A DEPUI system menu */

#ifndef MX_DEPUI_SYSMENU_HEADER
#   define MX_DEPUI_SYSMENU_HEADER
#   include "depui/depui.h"
#   ifdef __cplusplus
extern "C" {
#   endif
	typedef void (*MX_SYSMENU_FUNC) (void);

	typedef struct MX_SYSMENU_ENTRY {
		MX_STRING text;
		MX_SYSMENU_FUNC func;
	} MX_SYSMENU_ENTRY;

	typedef MX_VECTOR(MX_SYSMENU_ENTRY) MX_SYSMENU_ENTRYLIST;

	typedef struct MX_SYSMENU_ELEM {
		union {
			MX_LISTELEM_DATA listelem;
			MX_BUTTON_DATA button;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		MX_SYSMENU_FUNC func;
	} MX_SYSMENU_ELEM;

	typedef struct MX_SYSMENU_POPUP {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		MX_LIST list;
	} MX_SYSMENU_POPUP;

	typedef struct MX_SYSMENU {
		union {
			MX_BUTTON_DATA button;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		MX_SYSMENU_POPUP *_popup;
		MX_SYSMENU_ENTRYLIST _entries;
	} MX_SYSMENU;

	void mx_sysmenu_popup_handler(MX_WIN * win);

	void mx_sysmenu(void);
	void mx_sysmenu_add(const char *text, int len, MX_FREE dfree, MX_SYSMENU_FUNC func);

#   ifdef __cplusplus
}
#   endif
#endif
