/** !Horizontal and vertical sliders

This module contains code for horizontal and vertical sliders. */

#ifndef MX_DEPUI_SLIDER_HEADER
#   define MX_DEPUI_SLIDER_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
	typedef struct MX_SLIDER_DATA {
		union {
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		int _min;
		int _upper;
		int _lower;
		int _dim;
		int _range;
		int _size;
		int _value;
	} MX_SLIDER_DATA;

/** !Slider type */
	typedef struct MX_SLIDER {
		union {
			MX_SLIDER_DATA slider;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
	} MX_SLIDER;

/**type_conversion
!Convert to MX_SLIDER base object */
#   define MXSLIDER(o)         (&(o)->base.slider)

	void mx__slider_set(MX_SLIDER_DATA * slider, int range, int size, int value);

/** !Set the slider range size and value */
#   define mx_slider_set(s,r,si,v) mx__slider_set(MXSLIDER(s),(r),(si),(v))

	void mx__slider_to(MX_SLIDER_DATA * slider, int value);

/** !Move slider to a given position */
#   define mx_slider_to(s,v) mx__slider_to(MXSLIDER(s),(v))

	int mx__slider_value(const MX_SLIDER_DATA * slider);

/** !Return the slider value */
#   define mx_slider_value(s) mx__slider_value(MXSLIDER(s))

/**class !Class function for vertical MX_SLIDER */
	void mx_vslider_class(void);

	MX_SLIDER *mx__vslider(MX_SLIDER_DATA * slider, size_t size, MX_OBJ_DATA * parent, int id);

/** !Create vertical slider
This function creates a vertical slider as a child of another object. */
#   define mx_vslider(s,si,p,i) mx__vslider(MXSLIDER(s),(si),MXOBJ(p),(i))

/**class !Class function for horizontal MX_SLIDER */
	void mx_hslider_class(void);

	MX_SLIDER *mx__hslider(MX_SLIDER_DATA * slider, size_t size, MX_OBJ_DATA * parent, int id);

/** !Create horizontal slider
This function creates a horozontal slider as a child of another object. */
#   define mx_hslider(s,si,p,i) mx__hslider(MXSLIDER(s),(si),MXOBJ(p),(i))

#   ifdef __cplusplus
}
#   endif
#endif
