/** !A scrollable area
This module contains code for a scrollable area.  The area has
vertical or horizontal scrollbars as necessary to display all the objects 
contained in the scroll area. */

#ifndef MX_DEPUI_SCROLL_HEADER
#   define MX_DEPUI_SCROLL_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
	typedef struct MX_SCROLL_DATA {
		union {
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		int _x, _y;
		int _w, _h;
		int _vw, _vh;
		MX_SLIDER *_hscroll;
		MX_SLIDER *_vscroll;
		MX_OBJ *_corner;
	} MX_SCROLL_DATA;

/** !Scrollable area
This is an scrollable area object. */
	typedef struct MX_SCROLL {
		union {
			MX_SCROLL_DATA scroll;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
	} MX_SCROLL;

/**type_conversion
!Convert to MX_SCROLL base object */
#   define MXSCROLL(o)         (&(o)->base.scroll)

	void mx_scrollcorner_class(void);
	void mx_scrolltitle_class(void);

/**class
!Class function for MX_SCROLL */
	void mx_scroll_class(void);

	MX_SCROLL *mx__scroll(MX_SCROLL_DATA * scroll, size_t size, MX_OBJ_DATA * parent, int id);

/** !Create scrollable area
This macro creates an scrollable area object as a child of another object. */
#   define mx_scroll(s,si,p,i) mx__scroll(MXSCROLL(s), (si), MXOBJ(p), (i))

	void mx__scroll_reset(MX_SCROLL_DATA * scroll);

/** !Reset a MX_SCROLL area
This macro resets the scroll area to the upper left corner. */
#   define mx_scroll_reset(s) mx__scroll_reset(MXSCROLL(s))

	typedef struct MX_SCROLL2_DATA {
		union {
			MX_SCROLL_DATA scroll;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		MX_LOCK lock;
		MX_TEXTUAL text;
	} MX_SCROLL2_DATA;

/** !Scrollable area with title
This is an scrollable area object with a title. */
	typedef struct MX_SCROLL2 {
		union {
			MX_SCROLL2_DATA scroll2;
			MX_SCROLL_DATA scroll;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
	} MX_SCROLL2;

/**type_conversion
!Convert to MX_SCROLL2 base object */
#   define MXSCROLL2(o)         (&(o)->base.scroll2)

#   ifdef __cplusplus
}
#   endif
#endif
