#include "depui/depui.h"

#ifdef MX_PLATFORM_EMPTY

extern const MX_THEME mx_theme_empty;

static MX_PLATFORM_THEME mx__empty_themes[] = {
	{&mx_theme_empty, "empty theme"},
};

const MX_PLATFORM_FONT *mx_platform_font_system(const int i)
{
	(void) i;

	return 0;
}

void *mx_platform_font_load(const char *filename)
{
	(void) filename;

	return 0;
}

const char *mx_platform_font_path(void)
{
	return "*.*";
}

void mx_platform_font_free(void *font)
{
	(void) font;
}

unsigned int mx_platform_font_height(void *font)
{
	return 1;
}

unsigned int mx_platform_font_width(void *font, const char *text, long len)
{
	if (len > 0)
		return len;

	return strlen(text);
}

void mx_platform_modes(const MX_PLATFORM_DRIVER * d[], const MX_PLATFORM_RESOLUTION * r[], const MX_PLATFORM_DEPTH * c[],
					   const MX_PLATFORM_THEME * t[])
{
	*d = 0;
	*r = 0;
	*c = 0;
	*t = mx__empty_themes;
}

unsigned mx_platform_start(int w, int h, int c, const void *driver)
{
	(void) w;
	(void) h;
	(void) c;
	(void) driver;

	return true;
}

void mx_platform_stop(void)
{
}

unsigned mx_platform_clip(const MX_RECT * r)
{
	(void) r;
}

const MX_RECT *mx_platform_rect(void)
{
}

unsigned mx_platform_poll(void)
{
	return true;
}

void mx_platform_dirty(const MX_RECT * rect)
{
	(void) rect;
}

unsigned mx_platform_pointer(int *px, int *py, int *pb)
{
	*px = 0;
	*py = 0;
	*pb = 0;
}

unsigned mx_platform_key(int *scan, long *ascii)
{
	*scan = 0;
	*ascii = 0;
	return false;
}

void mx_theme_empty_textsize(void *font, const char *text, int l, int *w, int *h, int *last)
{
}

static unsigned mx_theme_empty_start(void)
{
	return true;
}

static void mx_theme_empty_stop(void)
{
}

static void mx_theme_empty_event(void)
{
	mx__event_default();
}

static void mx_theme_empty_obj(MX_OBJ * obj)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(obj);
	}
}

static void mx_theme_empty_vslider(MX_SLIDER * slider)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(slider);
	}
}

static void mx_theme_empty_hslider(MX_SLIDER * slider)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(slider);
	}
}

static void mx_theme_empty_textual_draw(const MX_TEXTUAL * textual, int x1, int y1, int x2, int y2, int offsetx, int offsety)
{
	long len = 0;
	const char *text = mx_string_text(&textual->_text, &len);

	if (text) {

	}
}

static void mx_theme_empty_textual(MX_TEXTUAL * text)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(text);

		mx_theme_empty_textual_draw(text, objrect->x1, objrect->y1, objrect->x2, objrect->y2, 0, 0);
	}
}

static void mx_theme_empty_scrollcorner(MX_OBJ * scrollcorner)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(scrollcorner);
	}
}

static void mx_theme_empty_scroll(MX_SCROLL * scroll)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(scroll);
	}
}

static void mx_theme_empty_button(MX_BUTTON * button)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(button);
		int offset = 0;

		if (mx_selected(button))
			offset = 1;

		mx_theme_empty_textual_draw(MXTEXTUAL(button), objrect->x1 + 1, objrect->y1 + 1, objrect->x2 - 1, objrect->y2 - 1, 1 + offset, 1 + offset);
	}
}

void mx_theme_empty_listelem(MX_LISTELEM * listelem)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(listelem);

		mx_theme_empty_textual_draw(MXTEXTUAL(listelem), objrect->x1, objrect->y1, objrect->x2, objrect->y2, 0, 0);
	}
}

static void mx_theme_empty_root(MX_WIN * root)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(root);
	}
}

static void mx_theme_empty_winborder(MX_WINBORDER * border)
{
	if (mx_exposing()) {
		MX_WIN *owner = MXOBJ(border)->_win;
		const MX_RECT *objrect = MXRECT(border);
		const int x1 = objrect->x1;
		const int y1 = objrect->y1;
		const int x2 = objrect->x2;
		const int y2 = objrect->y2;
	}
}

static void mx_theme_empty_win(MX_WIN * win)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(win);
	}
}

const MX_THEME mx_theme_empty = {
	mx_theme_empty_start,
	mx_theme_empty_stop,
	mx_theme_empty_event,
	mx_theme_empty_obj,
	mx_theme_empty_vslider,
	mx_theme_empty_hslider,
	mx_theme_empty_textual,
	mx_theme_empty_scrollcorner,
	mx_theme_empty_scroll,
	mx_theme_empty_button,
	mx_theme_empty_listelem,
	mx_theme_empty_root,
	mx_theme_empty_winborder,
	mx_theme_empty_win
};

#endif
