#include "depui/depui.h"

#ifdef MX_PLATFORM_DEGFX

#   include "degfx/degfx.h"

#   define MXMODULE_BITLINE
#   define MXMODULE_FONTDRAW

extern void mx__degfx_textchunks(const MX_TEXTUAL_DATA * textual, MX_PIXEL fore, int x, int y);

static unsigned mx_theme_default_start(void)
{
	return true;
}

static void mx_theme_default_stop(void)
{
}

static void mx_theme_default_event(void)
{
	mx__event_default();

	if ((mx.event == MX_DEFAULTRECT) && (MXID(mx.obj) == MXID_WINRESIZE)) {
		MX_RECT *rect = mx_defaultrect_data();

		rect->y2 = rect->y1 + (rect->y2 - rect->y1) / 2;
	}
}

static void mx_theme_default_obj(MX_OBJ * obj)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(obj);

		mx_rectfill(objrect->x1, objrect->y1, objrect->x2, objrect->y2, MXRGB(0, 0, 128));
	}
}

static void mx_theme_default_vslider(MX_SLIDER * slider)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(slider);
		MX_PIXEL fill = MXCOLOR_white;
		MX_PIXEL edge1 = MXCOLOR_grey25;
		MX_PIXEL edge2 = MXRGB(164, 164, 164);

		mx_frame(objrect->x1, objrect->y1, objrect->x2, objrect->y2, 1, MXRGB(128, 128, 128), MXRGB(128, 128, 128), MXRGB(192, 192, 192));

		if (mx_armed(slider)) {
			fill = MXCOLOR_grey50;
			edge1 = MXRGB(225, 225, 225);
			edge2 = MXCOLOR_grey25;
		}
		mx_frame(objrect->x1 + 1, objrect->y1 + slider->base.slider._upper, objrect->x2 - 1, objrect->y1 + slider->base.slider._lower, 1, edge2,
				 edge1, fill);
	}
}

static void mx_theme_default_hslider(MX_SLIDER * slider)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(slider);
		MX_PIXEL fill = MXCOLOR_white;
		MX_PIXEL edge1 = MXCOLOR_grey25;
		MX_PIXEL edge2 = MXRGB(164, 164, 164);

		mx_frame(objrect->x1, objrect->y1, objrect->x2, objrect->y2, 1, MXRGB(128, 128, 128), MXRGB(128, 128, 128), MXRGB(192, 192, 192));

		if (mx_armed(slider)) {
			fill = MXCOLOR_grey50;
			edge1 = MXRGB(225, 225, 225);
			edge2 = MXCOLOR_grey25;
		}

		mx_frame(objrect->x1 + slider->base.slider._upper, objrect->y1 + 1, objrect->x1 + slider->base.slider._lower, objrect->y2 - 1, 1, edge2,
				 edge1, fill);
	}
}

static MX_PIXEL mx_theme_default_textual_background(const MX_TEXTUAL_DATA * textual, int x1, int y1, int x2, int y2, unsigned armable)
{
	MX_PIXEL fore = MXCOLOR_black;
	MX_PIXEL back = MXBLENDT(MXCOLOR_wheat, MXCOLOR_white, 192);

	if (mx_selected(textual)) {
		back = MXCOLOR_wheat4;
		fore = MXCOLOR_white;
	}

	if (mx_disabled(textual))
		fore = MXCOLOR_grey50;

	if (mx_focused(textual))
		back = MXCOLOR_white;

	if ((armable) && (mx_armed(textual)))
		back = MXCOLOR_grey70;

	mx_rectfill(x1, y1, x2, y2, back);

	return fore;
}

static void mx_theme_default_textual(MX_TEXTUAL * text)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(text);

		MX_PIXEL fore = mx_theme_default_textual_background(MXTEXTUAL(text),
															objrect->x1,
															objrect->y1,
															objrect->x2,
															objrect->y2,
															false);

		mx__degfx_textchunks(MXTEXTUAL(text), fore, 0, 0);
	}
}

static void mx_theme_default_scrollcorner(MX_OBJ * scrollcorner)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(scrollcorner);

		mx_rectfill(objrect->x1, objrect->y1, objrect->x2, objrect->y2, MXCOLOR_wheat);
	}
}

static void mx_theme_default_scroll(MX_SCROLL * scroll)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(scroll);

		mx_rectfill(objrect->x1, objrect->y1, objrect->x2, objrect->y2, MXCOLOR_white);
	}
}

static void mx_theme_default_button(MX_BUTTON * button)
{
	if (mx_exposing()) {
		int offset = 0;
		MX_PIXEL fore;
		const MX_RECT *objrect = MXRECT(button);

		if (mx_selected(button))
			offset = 1;

		if (mx_armed(button))
			mx_box(objrect->x1, objrect->y1, objrect->x2, objrect->y2, 1, MXCOLOR_grey25, MXCOLOR_grey25);
		else if (mx_selected(button))
			mx_box(objrect->x1, objrect->y1, objrect->x2, objrect->y2, 1, MXCOLOR_grey25, MXCOLOR_grey75);
		else
			mx_box(objrect->x1, objrect->y1, objrect->x2, objrect->y2, 1, MXCOLOR_grey75, MXCOLOR_grey25);

		fore = mx_theme_default_textual_background(MXTEXTUAL(button), objrect->x1 + 1, objrect->y1 + 1, objrect->x2 - 1, objrect->y2 - 1, true);

		mx__degfx_textchunks(MXTEXTUAL(button), fore, 2 + offset, 2 + offset);
	}
}

void mx_theme_default_listelem(MX_LISTELEM * listelem)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(listelem);

		MX_PIXEL fore = mx_theme_default_textual_background(MXTEXTUAL(listelem),
															objrect->x1,
															objrect->y1,
															objrect->x2,
															objrect->y2, true);

		mx__degfx_textchunks(MXTEXTUAL(listelem), fore, 0, 0);
	}
}

static void mx_theme_default_root(MX_WIN * root)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(root);

		mx_rectfill(objrect->x1, objrect->y1, objrect->x2, objrect->y2, MXCOLOR_lightskyblue);
	}
}

static void mx_theme_default_winborder(MX_WINBORDER * border)
{
	if (mx_exposing()) {
		MX_WIN *owner = MXOBJ(border)->_win;
		const MX_RECT *objrect = MXRECT(border);
		const int x1 = objrect->x1;
		const int y1 = objrect->y1;
		const int x2 = objrect->x2;
		const int y2 = objrect->y2;
		MX_PIXEL fore = MXCOLOR_black;
		MX_PIXEL fill = MXCOLOR_wheat3;

		if (mx_active(owner))
			fill = MXCOLOR_lemon;

		if (mx_disabled(owner))
			fore = MXCOLOR_grey50;

		mx_box(x1, y1, x2, y2, 1, MXCOLOR_grey25, MXCOLOR_grey25);
		mx_rectfill(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fill);

		if (owner)
			mx__degfx_textchunks(MXTEXTUAL(owner), fore, mx_x(border) - mx_x(owner) + 2, mx_y(border) - mx_y(owner) + 2);
	}
}

static void mx_theme_default_win(MX_WIN * win)
{
	if (mx_exposing()) {
		const MX_RECT *objrect = MXRECT(win);

		mx_rectfill(objrect->x1, objrect->y1, objrect->x2, objrect->y2, MXCOLOR_wheat);
	}
}

const MX_THEME mx_theme_default = {
	mx_theme_default_start,
	mx_theme_default_stop,
	mx_theme_default_event,
	mx_theme_default_obj,
	mx_theme_default_vslider,
	mx_theme_default_hslider,
	mx_theme_default_textual,
	mx_theme_default_scrollcorner,
	mx_theme_default_scroll,
	mx_theme_default_button,
	mx_theme_default_listelem,
	mx_theme_default_root,
	mx_theme_default_winborder,
	mx_theme_default_win
};

#endif
