#ifndef MX__DEPUI_PLATFORM_HEADER
#define MX__DEPUI_PLATFORM_HEADER

#if !defined(MX_PLATFORM_DEGFX) && !defined(MX_PLATFORM_ALLEGRO) && !defined(MX_PLATFORM_EMPTY) && !defined(MX_PLATFORM_TURBOC) && !defined(MX_PLATFORM_MGRX) && !defined(MX_PLATFORM_GENERIC)
#define MX_PLATFORM_DEGFX
#endif

#ifdef __cplusplus
extern "C" {
#endif
#include "deds/rect.h"
#include "depui/types.h"

/* Theme functions */ 
typedef struct MX_THEME {
		unsigned (*start) (void);
		void (*stop) (void);
		void (*event) (void);
		void (*obj) (struct MX_OBJ * obj);
		void (*vslider) (struct MX_SLIDER * slider);
		void (*hslider) (struct MX_SLIDER * slider);
		void (*textual) (struct MX_TEXTUAL * text);
		void (*scrollcorner) (struct MX_OBJ * scrollcorner);
		void (*scroll) (struct MX_SCROLL * scroll);
		void (*button) (struct MX_BUTTON * button);
		void (*listelem) (struct MX_LISTELEM * listelem);
		void (*root) (struct MX_WIN * root);
		void (*winborder) (struct MX_WINBORDER * border);
		void (*win) (struct MX_WIN * win);
	} MX_THEME;

#if defined(MX_PLATFORM_ALLEGRO)
	extern const MX_THEME mx_theme_default;

#elif defined(MX_PLATFORM_EMPTY)
	extern const MX_THEME mx_theme_empty;

#elif defined(MX_PLATFORM_DEGFX)
	extern const MX_THEME mx_theme_win95;
	extern const MX_THEME mx_theme_rounded;
	extern const MX_THEME mx_theme_default;

#elif defined(MX_PLATFORM_MGRX)
	extern const MX_THEME mx_theme_mgrx;

#elif defined(MX_PLATFORM_TURBOC)
	extern const MX_THEME mx_theme_bgi;

#else
#error Error: Unknown DEPUI platform
#endif

/* Platform font functions */
	typedef struct MX_PLATFORM_FONT {
		void *font;
		const char *text;
	} MX_PLATFORM_FONT;

	const MX_PLATFORM_FONT *mx_platform_font_system(const int i);
	void *mx_platform_font_load(const char *filename);
	void mx_platform_font_free(void *font);
	const char *mx_platform_font_path(void);

	unsigned int mx_platform_font_height(void *font);
	unsigned int mx_platform_font_width(void *font, const char *text, int len);

/* Platform functions */
	typedef struct MX_PLATFORM_DRIVER {
		const void *driver;
		const char *text;
	} MX_PLATFORM_DRIVER;

	typedef struct MX_PLATFORM_RESOLUTION {
		int w, h;
		const char *text;
	} MX_PLATFORM_RESOLUTION;

	typedef struct MX_PLATFORM_DEPTH {
		int c;
		const char *text;
	} MX_PLATFORM_DEPTH;

	typedef struct MX_PLATFORM_THEME {
		const MX_THEME *theme;
		const char *text;
	} MX_PLATFORM_THEME;

	unsigned mx_platform_clip(const MX_RECT * r);
	void mx_platform_modes(const MX_PLATFORM_DRIVER * d[],
						   const MX_PLATFORM_RESOLUTION * r[],
						   const MX_PLATFORM_DEPTH * c[],
						   const MX_PLATFORM_THEME * t[]);
	unsigned mx_platform_start(int w, int h, int c, const void *driver);
	void mx_platform_stop(void);
	const MX_RECT *mx_platform_rect(void);
	unsigned mx_platform_poll(void);
	void mx_platform_dirty(const MX_RECT * rect);
	unsigned mx_platform_pointer(int *px, int *py, int *pb);
	unsigned mx_platform_key(int *scan, int *ascii);

#ifdef __cplusplus
}
#endif
#endif
