/** !A graphics mode and theme selector
This module implements a dialog to select and possibly change the
graphics mode an theme.
<p>
When a graphics mode/theme is selected the window sends a MX_GFXSEL_OK
event to the parent window.  The window can get information about the
selected graphics mode and theme using the mx_gfxsel_info() function.  The
information can also be modified by the parent window.  If the parent window
does not reply to the MX_GFXSEL_OK event (or replies with 0), then the
graphics mode/theme gets changed. */

#ifndef MX_DEPUI_GFXSEL_HEADER
#   define MX_DEPUI_GFXSEL_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
/** !Graphics mode selector */ typedef struct MX_GFXSEL {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;

		MX_BUTTON _ok;
		MX_BUTTON _apply;
		MX_LIST _res;
		MX_LIST _depth;
		MX_LIST _driver;

		int _resw, _depthw, _driverw;
	} MX_GFXSEL;

	void mx_gfxsel_handler(MX_WIN * win);
	MX_GFXSEL *mx_gfxselwin(MX_GFXSEL * gfx, size_t size, MX_HANDLER handler, int id);

/** !Create a graphics mode and theme selector. */
#   define mx_gfxsel(id) mx_gfxselwin(0, 0, 0, (id))

/** !Graphics mode selector information
When a graphics mode has been selected by the dialog a MX_GFXSEL_OK
event is sent to the parent window.  Then mx_gfxsel_info() can be called to
get information about the graphics mode selected.  A pointer to this type is
returned. */
	typedef struct MX_GFXSEL_INFO {
		int idnum;
		int w, h, c;
		const void *driver;
	} MX_GFXSEL_INFO;

	MX_GFXSEL_INFO *mx_gfxsel_info(const int idnum);

#   ifdef __cplusplus
}
#   endif
#endif
