/** !A font selector and loader
This module implements a font selector dialog. */

#ifndef MX_DEPUI_FONTSEL_HEADER
#   define MX_DEPUI_FONTSEL_HEADER

#   include "depui/depui.h"
#   include <assert.h>

#   ifdef __cplusplus
extern "C" {
#   endif
/** !A font seletion window */ typedef struct MX_FONTSEL {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;

		MX_LIST _fonts;
		MX_BUTTON _load;
		MX_BUTTON _apply;
		MX_BUTTON _ok;
		MX_GUIFONT *_chosen;
	} MX_FONTSEL;

	void mx_fontsel_handler(MX_WIN * win);
	MX_FONTSEL *mx_fontselwin(MX_FONTSEL * sel, size_t size, MX_HANDLER handler, int id);

/** !Create a font selector window
This macro creates a font selector with the specified id number. */
#   define mx_fontsel(id) mx_fontselwin(0, 0, 0, (id))

	void mx_fontsel_refresh(MX_FONTSEL * fsel);

	MX_GUIFONT *mx_fontsel_info(const int idnum);

#   ifdef __cplusplus
}
#   endif
#endif
