/** !A file selector
This module implements a file selector object. */

#ifndef MX_DEPUI_FILESEL_HEADER
#   define MX_DEPUI_FILESEL_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
/** !File selector window
This type is a standard DEPUI file selector. */ typedef struct MX_FILESEL {
		union {
			MX_WIN_DATA win;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;

		MX_LIST _dirs;
		MX_LIST _files;
		MX_BUTTON _ok;
		MX_EDITTEXT _file;
		unsigned _existing;
	} MX_FILESEL;

	void mx_filesel_handler(MX_WIN * win);
	MX_FILESEL *mx_fileselwin(MX_FILESEL * sel, size_t size, MX_HANDLER handler, int id);

/** !Create a file selector window
This macro creates a file selector with the given id number. */
#   define mx_filesel(id) mx_fileselwin(0, 0, 0, (id))

	void mx_filesel_path(MX_FILESEL * sel, const char *path, int len);

	void mx_filesel_existing(MX_FILESEL * sel, unsigned exist);

	void mx_filesel_refresh(MX_FILESEL * sel);

	const char *mx_filesel_info(const int idnum);

#   ifdef __cplusplus
}
#   endif
#endif
