/** !An editable text object
This module implements an editable textual object.
<p>It is derived from MX_TEXTUAL and inherits several important functions 
(text set/get/align etc.) from MX_TEXTUAL. */

#ifndef MX_DEPUI_EDITTEXT_HEADER
#   define MX_DEPUI_EDITTEXT_HEADER

#   include "depui/depui.h"

#   ifdef __cplusplus
extern "C" {
#   endif
	typedef struct MX_EDITTEXT_DATA {
		union {
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
		 MX_VECTOR(char) _text;

		int _cursor;
		int _pixeloffset;
		MX__TEXTCHUNK *_cursorchunk;
		MX__TEXTCHUNK *_cursorpointedchunk;
	} MX_EDITTEXT_DATA;

/** !An editable text object */
	typedef struct MX_EDITTEXT {
		union {
			MX_EDITTEXT_DATA edittext;
			MX_TEXTUAL_DATA textual;
			MX_OBJ_DATA obj;
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
	} MX_EDITTEXT;

/**type_conversion
!Convert to base MX_EDITTEXT object */
#   define MXEDITTEXT(o)        (&(o)->base.edittext)

	MX_EDITTEXT *mx__edittext(MX_EDITTEXT_DATA * edit, size_t size, MX_OBJ_DATA * parent, int id);

/** !Create an editable text object
This macro creates an editable textual object as a child of another object. */
#   define mx_edittext(m,s,p,i) mx__edittext(MXEDITTEXT(m),(s),MXOBJ(p),(i))

	void mx__edittext_zeroterminate(MX_EDITTEXT_DATA * edit);

/** !Force zero termination if internal string
This function forces the editable text to be zero terminated. */
#   define mx_edittext_zeroterminate(e) mx__edittext_zeroterminate(MXEDITTEXT(e))

	void mx__edittext_cursorpos(MX_EDITTEXT_DATA * edit, int newpos);

/** !Set cursor position
This function sets the cursor position in the editable text. */
#   define mx_edittext_cursorpos(e,p) mx__edittext_cursorpos(MXEDITTEXT(e),(p))

	void mx__edittext_cursorscroll(MX_EDITTEXT_DATA * edit);

/** !Make the MX_EDITTEXT request a scroll to make the cursor visible */
#   define mx_edittext_cursorscroll(e) mx__edittext_cursorscroll(MXEDITTEXT(e))

#   ifdef __cplusplus
}
#   endif
#endif
