/**author <a href="depui.htm">DEPUI</a> written by Doug Eleveld (deleveld@dds.nl) */

#ifndef MX_DEPUI_HEADER
#define MX_DEPUI_HEADER

#define MX_DEPUI_VERSION 3
#define MX_DEPUI_SUBVERSION 3

/* Optional theme modules defines */
#if defined(MXMODULE_THEME_ALL) || !defined(MX__DEPUI_SOURCE_LIBRARY)
#define MXMODULE_THEME_DEFAULT
#define MXMODULE_THEME_WIN95
#define MXMODULE_THEME_ROUNDED
#endif

#if !defined(MXMODULE_THEME_DEFAULT) && !defined(MXMODULE_THEME_WIN95) && !defined(MXMODULE_THEME_ROUNDED)
#define MXMODULE_THEME_DEFAULT
#endif

/**todo Does the opendir/readdir/closedir bug still exist in TinyC compiler? */
#if defined(__TINYC__) || defined(__DMC__) || defined(__WATCOMC__)
#define MXMODULE_DIRENT
#endif

#ifdef __TURBOC__
#define MX_PLATFORM_TURBOC
#endif

/* Core modules */
#include "detk/detk.h"
#include "deds/deds.h"
#include "depui/types.h"
#include "depui/platform.h"
#include "depui/corepui.h"

/* Extra modules */
#include "depui/slider.h"
#include "depui/scroll.h"
#include "depui/list.h"
#include "depui/edittext.h"
#include "depui/gfxsel.h"
#include "depui/filesel.h"
#include "depui/fontsel.h"
#include "depui/textedit.h"
#include "depui/alert.h"
#include "depui/themesel.h"
#include "depui/sysmenu.h"

#endif

/**library !A GPL portable gui library
<A HREF="depui.jpg"><IMG SRC="depuith.jpg"></A>
<A HREF="depui1.jpg"><IMG SRC="depui1th.jpg"></A>
<A HREF="depui2.jpg"><IMG SRC="depui2th.jpg"></A>
<p>
Take a look at the [<a href="history.txt">changelog</a>]
[Page at <a href="http://freshmeat.net/projects/depui/">Freshmeat</a>] <br>
Download [<a href="../depui30/depui30.zip">DEPUI 3.0 (stable)</a>] 
[<a href="depui33.zip">DEPUI 3.3 (Work-in-progress)</a>]
<p>
DEPUI is a small extremely portable user interface library.  It uses an object oriented C API with reference counting for
many of the objects.  The majority of DEPUI souce code is independant of the supporting graphics library, all
platform dependent functions are in a single file.  DEPUI uses the 
<a href="deds.htm">DEDS</a> library for data structures and the 
<a href="detk.htm">DETK</a> library for assorted gui functions.  For drawing on the screen
DEPUI can use several different libraries:  
    <UL>
    <LI><a href="degfx.htm">DEGFX</a> (tested on djgpp, mingw, Borland free compiler, Open Watcom, linux svgalib)</LI>
    <LI><a href="http://alleg.sourceforge.net/">Allegro</a> (tested on DOS)</LI>
    <LI><a href="http://mgrx.fgrim.com/">MGRX</a> (tested on djgpp, mingw, x11 and linux framebuffer)</LI>
    <LI>Borland Turbo C++ 3.1 DOS compiler using BGI graphics</LI>
    </UL>
<h2>Features:</h2>
<UL>
<LI>Clean object oriented C API</LI>
<LI>Memory efficient and fast</LI>
<LI>Extensive documentation using <a href="mxdoc.htm">MXDOC 2.0</a>, 
<a href="doxygen/index.htm">Doxygen</a> and <a href="global/HTML/index.html">GNU GLobal</a></li>
<LI>Themes and GFX mode changable at runtime</LI>
<LI>Widgets:
    <UL>
    <LI>Text objects</LI>
    <LI>Editable text objects</LI>
    <LI>Buttons</LI>
    <LI>Horizontal and vertical sliders</LI>
    <LI>Scrollable area</LI>
    <LI>Lists with scrollbars if necessary</LI>
    <LI>Windows and window borders</LI>
    <LI>Child windows and modal windows</LI>
    <LI>Graphic mode/theme window</LI>
    <LI>File selector window</LI>
    <LI>Font selector window and run-time loadable fonts (depending on the platform)</LI>
    </UL></LI>
<LI>Objects can be transparent and can have any shape</LI>

<LI>Library source is completly self-contained - You dont have to link to external libraries, not even to DEPUI!</LI>

<LI>DEPUI uses #define flags to determine which modules to use.  This guarantees that only the portions of DEPUI that you 
actually use get included in your executable.</LI>

<LI>All platform dependant code in a single file for platform/theme code</LI>

<LI>Runs on almost any hardware, even my 40 MHz 386 test machine</LI>
<LI>Compiles with no changes on MSB first or LSB first hardware</LI>
<LI>Open source and GPL licence</LI>
</UL>
*/
