#include "depui/depui.h"
#include <string.h>

void mx_alert_handler(MX_WIN * win)
{
	MX_ALERT *alert = (MX_ALERT *) win;

	/* Pick some default size */
	if (mx_eventmatch(MX_DEFAULTRECT, win)) {
		int w, h;
		MX_RECT text;
		MX_RECT *rrect = mx_defaultrect_data();

		mx_defaultrect(&alert->text, &text);

		w = text.x2 - text.x1;
		h = text.y2 - text.y1;

		rrect->x2 = rrect->x1 + w;
		rrect->y2 = rrect->y1 + h;
		return;

		/* Place the objects in a nice place when geometry is set */
	} else if (mx_eventmatch(MX_GEOMETRY, win)) {
		mx_default_handler();

		mx_defaultrect(&alert->text, 0);
		mx_move(&alert->text, 0, 0);
		return;

	} else if (mx_eventmatch(MX_THEME_CHANGE, win)) {
		mx_default_handler();
		mx_defaultrect(alert, 0);
		mx_geometry(alert);
		return;
	}

	mx_default_handler();
}

MX_ALERT *mx_alertwin(MX_ALERT * alert, size_t size, MX_HANDLER handler, int theid)
{
	MXMINSIZE(size, MX_ALERT);

	if (!handler)
		handler = mx_alert_handler;

	alert = (MX_ALERT *) mx_win(alert, size, handler, theid);
	if (alert) {
		mx_text_set(alert, "Alert", -1, 0);

		mx_textual(&alert->text, 0, alert, theid);
		mx_move(&alert->text, 0, 0);
	}
	return alert;
}
