#ifndef MX__DEGFX_RGB555_HEADER
#define MX__DEGFX_RGB555_HEADER

#ifdef MX_DEGFX_ENCODING
#error "Cant have more than one DEGFX encoding"
#endif
#define MX_DEGFX_ENCODING

typedef unsigned short MX_PIXEL;

#define MXRGB(r, g, b) (((((MX_PIXEL)r) & 0x00f8) << 7) | \
                        ((((MX_PIXEL)g) & 0x00f8) << 2) | \
                        ((((MX_PIXEL)b) & 0x00f8) >> 3))
#define MX__TRANSCOLOR MXRGB(255, 0, 255)

#define MXRGBT(r, g, b, a) (((a) > 128) ? (MX__TRANSCOLOR) : MXRGB(r, g, b))

#define MXT(c) (((c) == MX__TRANSCOLOR) ? (0xff) : (0))
#define MXR(c) (((c) & 0x7c00) >> 7)
#define MXG(c) (((c) & 0x03e0) >> 2)
#define MXB(c) (((c) & 0x001f) << 3)

#define MXTRANS(c, a) (((a) > 128) ? (MX__TRANSCOLOR) : (a))

#define MXBLENDT(c1, c2, a1) \
                (((a1) >= 255) ? (c2) : (((a1) == 0) ? (c1) : \
                 (((((unsigned long)(c1) & 0x7c00ul) * (256u - (a1)) + ((unsigned long)(c2) & 0x7c00ul) * (a1)) & 0x7c0000ul) | \
                  ((((unsigned long)(c1) & 0x03e0ul) * (256u - (a1)) + ((unsigned long)(c2) & 0x03e0ul) * (a1)) & 0x03e000ul) | \
                  ((((unsigned long)(c1) & 0x001ful) * (256u - (a1)) + ((unsigned long)(c2) & 0x001ful) * (a1)) & 0x001f00ul)) >> 8))

#define MXBLEND(c1, c2)      (((c1) != MX__TRANSCOLOR) ? (c1) : (c2))

#define MXRGB332(c) ((((c) & 0x7000) >> 7) | \
                     (((c) & 0x0380) >> 5) | \
                     (((c) & 0x0018) >> 3))

#define MXRGB555(c) (c)

#define MXRGB565(c) ((((c) & 0x7c00) << 1) | \
                     (((c) & 0x03e0) << 1) | \
                     (((c) & 0x001f) << 0))

#define MXRGB888(c) (((((unsigned long)c) & 0x7c00) << 9) | \
                     ((((unsigned long)c) & 0x03e0) << 6) | \
                     ((((unsigned long)c) & 0x001f) << 3))

#endif
