#ifndef MX__DEGFX_RGB332_HEADER
#define MX__DEGFX_RGB332_HEADER

#ifdef MX_DEGFX_ENCODING
#error "Cant have more than one DEGFX encoding"
#endif
#define MX_DEGFX_ENCODING

typedef unsigned char MX_PIXEL;

#define MXRGB(r, g, b) (((((MX_PIXEL)r) & 0xe0) << 0) | \
                        ((((MX_PIXEL)g) & 0xe0) >> 3) | \
                        ((((MX_PIXEL)b) & 0xc0) >> 6))
#define MX__TRANSCOLOR MXRGB(255, 0, 255)

#define MXRGBT(r, g, b, a) (((a) > 128) ? (MX__TRANSCOLOR) : MXRGB(r, g, b))

#define MXT(c) (((c) == MX__TRANSCOLOR) ? (0xff) : (0))
#define MXR(c) ((c) & 0xe0)
#define MXG(c) (((c) & 0xe3) << 3)
#define MXB(c) (((c) & 0x03) << 6)

#define MXTRANS(c, a) (((a) > 128) ? (MX__TRANSCOLOR) : (a))

#define MXBLENDT(c1, c2, a1) \
                (((a1) >= 255) ? (c2) : (((a1) == 0) ? (c1) : \
                 (((((c1) & 0x00E0u) * (256u - (a1)) + ((c2) & 0x00E0u) * (a1)) & 0xE000u) | \
                  ((((c1) & 0x001Cu) * (256u - (a1)) + ((c2) & 0x001Cu) * (a1)) & 0x1C00u) | \
                  ((((c1) & 0x0003u) * (256u - (a1)) + ((c2) & 0x0003u) * (a1)) & 0x0300u)) >> 8))

#define MXBLEND(c1, c2)      (((c1) != MX__TRANSCOLOR) ? (c1) : (c2))

#define MXRGB332(c) (c)

#define MXRGB555(c) (((((unsigned int)c) & 0xe0) << 9) | \
                     ((((unsigned int)c) & 0x1c) << 5) | \
                     ((((unsigned int)c) & 0x02) << 3))

#define MXRGB565(c) (((((unsigned int)c) & 0xe0) << 10) | \
                     ((((unsigned int)c) & 0x1c) << 6) | \
                     ((((unsigned int)c) & 0x02) << 3))

#define MXRGB888(c) (((((unsigned long)c) & 0xe0) << 16) | \
                     ((((unsigned long)c) & 0x1c) << 11) | \
                     ((((unsigned long)c) & 0x02) << 6))

#endif
