#include "degfx/font.h"

MX__FONT_INDEX *mx__font_range(const MX_FONT * font, const long c)
{
	unsigned int i;
	MX__FONT_INDEX *findex = font->_index;

	/* Look in all the font sections */
	for (i = 0; i < font->_sections; i++) {

		/* Is the character in the range of the font */
		if ((c >= findex->_start) && (c < (findex->_start + 128)))
			return findex;

		/* The sections are in ascending order, are we past it? */
		else if (c < findex->_start)
			return 0;

		++findex;
	}
	return 0;
}
