#include "degfx/font.h"

void mx__font_bytechar(MX_BITMAP * bitmap, const MX_RECT * charrect, const MX_RECT * drawrect, const unsigned char *data, unsigned int width,
					   MX_PIXEL color)
{
	int r;
	unsigned int xoff, yoff, x2off;
	const unsigned int opaque = 0xff - MXT(color);

	xoff = drawrect->x1 - charrect->x1;
	yoff = drawrect->y1 - charrect->y1;
	x2off = charrect->x2 - drawrect->x2;

	data += yoff * width;

	for (r = drawrect->y1; r <= drawrect->y2; r++) {

		MX_BITMAP_ITER iter = mx_bitmap_iter(bitmap, drawrect->x1, r);
		const MX_BITMAP_ITER end = mx_bitmap_iter(bitmap, drawrect->x2, r);

		data += xoff;

		if (opaque == 0xff) {
			while (iter <= end) {
				*iter = MXBLENDT(color, *iter, 0xff - *data);
				++iter;
				++data;
			}
		} else {
			while (iter <= end) {
				*iter = MXBLENDT(color, *iter, 0xff - *data * opaque / 0xff);
				++iter;
				++data;
			}
		}

		/* Skip data to the right if the right side is clipped */
		data += x2off;
	}
}
