/** !Font functions
This module contains functions related to font drawing . */

#ifndef MX__DEGFX_FONT_HEADER
#define MX__DEGFX_FONT_HEADER

#include "deds/bool.h"
#include "deds/vector.h"
#include "detk/utf8.h"
#include "degfx/bitmap.h"

#ifdef __cplusplus
extern "C" {
#endif

	/* The Font driver */
	typedef struct MX__FONT_INDEX {
		long _start;			/* Character number to start with */
		unsigned int _index[128];	/* Indicies in data of each character */
		unsigned int _width[128];	/* Width of each character */
	} MX__FONT_INDEX;

	typedef void (*MX_FONT_DRAWER) (struct MX_BITMAP * bitmap,
									const MX_RECT * charrect,
									const MX_RECT * drawrect,
									const unsigned char *data,
									unsigned int width, MX_PIXEL color);

    /**font !A font */
	typedef struct MX_FONT {
		union {
			MX_ATOM atom;
		} base;

		unsigned int _height;
		unsigned int _sections;	/* Number of index section in the font */

		MX__FONT_INDEX *_index;	/* Pointer to index data */
		unsigned char *_data;	/* Pointer to font data */
		unsigned int _datalen;

		/* Callbacks for handling fonts */
		MX_FONT_DRAWER _drawchar;
	} MX_FONT;

	MX_FONT *mx_font(const int height);
	MX_FONT *mx_font_bitmap(const struct MX_BITMAP *bitmap, int start);
	MX_FONT *mx_font_pcx(const char *filename, int start);

/** !Set the default font */
	void mx_font_default(MX_FONT * font);

/** !Draw text onto a bitmap */
	void mx_font_bitmap_draw(const MX_FONT * font, struct MX_BITMAP *bitmap,
							 const char *text, int len, int x, const int y,
							 const MX_PIXEL fore);

/** !Draw a block of text onto a bitmap */
	void mx_font_bitmap_drawblock(const MX_FONT * font,
								  struct MX_BITMAP *bitmap, const char *text,
								  int len, int x, int y, const MX_PIXEL fore);

/** !Draw text onto the screen */
#define mx_font_draw(f,t,l,x,y,fore) mx_font_bitmap_draw((f),MXSCREEN,(t),(l),(x),(y),(fore))

/** !Draw a block of text onto the screen */
#define mx_font_drawblock(f,t,l,x,y,fore) mx_font_bitmap_drawblock((f),MXSCREEN,(t),(l),(x),(y),(fore))

/** !Return the height of a font */
	unsigned int mx_font_height(const MX_FONT * font);

/** !Return the width of a portion of text */
	unsigned int mx_font_width(const MX_FONT * font, const char *text, int len);

/** !Return the size of a block for a portion of text */
	void mx_font_blocksize(const MX_FONT * font, const char *text, int len,
						   int *tw, int *th, int *last);

    typedef MX_REF(MX_FONT) MX_FONTREF;
    extern MX_FONTREF mx__fontref;

	/* Private font drawing functions */
	extern MX__FONT_INDEX *mx__font_range(const MX_FONT * font, const long c);

	void mx__font_bitchar(struct MX_BITMAP *bitmap, const MX_RECT * charrect,
						  const MX_RECT * drawrect, const unsigned char *data,
						  unsigned int width, MX_PIXEL color);
	void mx__font_bytechar(struct MX_BITMAP *bitmap, const MX_RECT * charrect,
						   const MX_RECT * drawrect, const unsigned char *data,
						   unsigned int width, MX_PIXEL color);

    /** !Builtin 8x8 font */
	extern MX_FONT mx_font_8x8;

    /** !Builtin 8x14 font */
	extern MX_FONT mx_font_8x14;

    /** !Builtin 8x16 font */
	extern MX_FONT mx_font_8x16;
    
#if defined(MXMODULE_FONT_ALL) || !defined(MX__DEPUI_SOURCE_LIBRARY)
#define MXMODULE_FONT_8X8
#define MXMODULE_FONT_8X14
#define MXMODULE_FONT_8X16
#endif

#if !defined(MXMODULE_FONT_8X8) && !defined(MXMODULE_FONT_8X14) && !defined(MXMODULE_FONT_8X16)
#define MXMODULE_FONT_8X8
#endif

#if defined(MXMODULE_FONT_8X8)
#ifndef MX_FONT_DEFAULT
#define MX_FONT_DEFAULT mx_font_8x8
#endif
#endif
    
#if defined(MXMODULE_FONT_8X14)
#ifndef MX_FONT_DEFAULT
#define MX_FONT_DEFAULT mx_font_8x14
#endif
#endif
    
#if defined(MXMODULE_FONT_8X16)
#ifndef MX_FONT_DEFAULT
#define MX_FONT_DEFAULT mx_font_8x16
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif
