#include "degfx/driver.h"

#ifdef MX__DRIVER_EMPTY

#   include <stdlib.h>
#   include <stdio.h>

static unsigned mx__empty_start(MX_GFX_ARGS * args)
{
	printf("DEGFX empty driver start 640x480x16\n");

	args->w = 640;
	args->h = 480;
	args->c = 4;
	args->title = "empty";
	args->pointer = false;

	mx_drs_area(args->w - 1, args->h - 1);

	return true;
}

static void mx__empty_stop(void)
{
	printf("DEGFX empty driver stop\n");
}

static unsigned mx__empty_poll(void)
{
	printf("DEGFX empty driver poll\n");
	return true;
}

static void mx__empty_dirty(const MX_RECT * rect)
{
	printf("DEGFX empty driver dirty %i,%i,%i,%i\n", rect->x1, rect->y1, rect->x2, rect->y2);
}

static unsigned mx__empty_mouse(void)
{
	return false;
}

static unsigned mx__empty_key(int *scan, int *ascii)
{
	(void) scan;
	(void) ascii;

	return false;
}

const MX_DRIVER mx__empty = {
	mx__empty_start,
	mx__empty_stop,

	mx__empty_poll,
	mx__empty_dirty,

	mx__empty_mouse,
	mx__empty_key
};

#endif
