/**author <a href="degfx.htm">DEGFX</a> written by Doug Eleveld (deleveld@dds.nl) */

#ifndef MX__DEGFX_HEADER
#define MX__DEGFX_HEADER

#define MX_DEGFX_VERSION 1
#define MX_DEGFX_SUBVERSION 2

#include "degfx/types.h"
#include "degfx/colors.h"
#include "degfx/bitmap.h"
#include "degfx/driver.h"
#include "degfx/font.h"
#include "degfx/coregfx.h"

#endif

/**library !A GPL portable graphics library
<A HREF="degfx.jpg"><IMG SRC="degfxth.jpg"></A>
<p>
DEGFX is a small extremely portable graphics library.  It has only 6 (!) platform dependant functions. It uses a clean
object oriented C API with reference counting and delete locking for (almost) all the objects.  The library supports transparency for bitmaps and
all drawing functions and antialiased fonts.  The user has very fast pixel level access to bitmaps using
iterators.  DEGFX uses the <a href="deds.htm">DEDS</a> library for data structures.
Compared to other portable graphics libraries DEGFX is:
<UL>
    <LI>Smaller and simpler than Allegro or SDL</LI>
    <LI>Fast alpha-blending (transparency, anti-aliasing) built into all drawing functions</LI>
    <LI>Color conversions are completely hidden to the user</LI>
    <LI>More graphic functions (line, blit) than SDL</LI>
    <LI>More portable than SDL (doesn't need threads)</LI>
    <LI>Guaranteed flicker-free graphics without double buffering the entire display</LI>
    <LI>Library source is completly self-contained - You dont have to link to external libraries, not even to DEGFX!</LI>
    <LI>Easy to determine which modules (drivers, fonts etc...) are included in the executable</LI>
    <li>Portable gui available (<a href="depui.htm">DEPUI</a>)</li>
</UL>
DEGFX uses a different approach than most graphics libraries.
<UL>
    <LI>DEGFX works works internally only a single pixel format chosen at compile time.  This can be argb8888, rgb555 or rgb332 
    color encodings.  This makes the library internally very simple.  Bitmap are only converted to the screen color depth when 
    actually writing to the screen.  This has the advantage
    that the library internals are very simple and allows transparency and alpha-blending to be used even for monochrome, 
    4-bit and 8-bit displays.  Admittedly a program that makes heavy use of antialiasing and transparency might not look very 
    good on a 4-bit display.</LI>
    
    <LI>DEGFX uses a buffer system to guarantee no screen flicker when drawing but uses much less memory than the usual method
    of double buffering the  entire screen.  Only a portion of the screen is buffered at a time and the users
    redraw callback function is called multiple times with different clipping settings.  Because a clipped graphics drawing
    can be made very fast, calling the update function many times is hardly slower than full screen double buffering but uses
    much less memory.  In fact the smaller buffer can often be faster than full screen double buffering because of better 
    cache behavior.  In any case you can change how much memory you want to use for the screen buffer (even during runtime) so 
    you can do do full double buffering if you want to, or use minimal memory and (maybe) have a slightly slower screen update speed.
    </LI>
    
    <LI>DEGFX does not require linking to a library, you include the DEGFX C source code directly into you own programs.
    So installing or removing DEGFX from your system is as simple as moving or deleting a directory from your
    compilers include path.  Using this method can cause long compile times since you are essentially compiling the library
    every time you compile your program.  But if you include DEGFX in a separate object file you can solve this problem.</LI>

    <LI>DEGFX uses #define flags to determine which modules to use.  This guarantees that only the portions of DEGFX that you 
    actually use get included in your executable.</LI>
</UL>
Some Features:
<UL>
<LI>Object oriented C API with attention to maximum type safety. </LI>
<LI>Fast, unified transparency support</LI>
<UL>
    <LI>Plot a solid blue pixel: mx_pixel(x, y, MXRGB(0,0,255));</LI>
    <LI>Same pixel with 50% transparency: mx_pixel(x, y, MXRGBT(0,0,255,128));</LI>
    <LI>RBG and RGBT colors are compile time macro for fast execution</LI>
    <LI>Transparency works for ALL displays even 8 bit and 4 bit graphic modes</LI>
</UL>
<LI>Unified reference counting for many objects</LI>
<LI>Copying to screen is localized by buffer system so banked modes work almost as fast as linear modes</LI>
<LI>Bitmap support:</LI>
<UL>
    <LI>Pixel RGB colors are compile time constants</LI>
    <LI>Color conversions are completely hidden from user</LI>
    <LI>Unified transparency support</LI>
    <LI>Drawing functions: pixel, line, blit, etc...</LI>
    <LI>Drawing functions are simple and fast because only 32 bit ARGB is needed</LI>
    <LI>Very fast pixel-level access using iterators</LI>
    <LI>Functions to load bitmaps from files (PCX, TGA, GIF)</LI>
    <LI>Named colors (derived from X11 rgb.txt)</LI>
    <LI>Reference counting and delete locking</LI>
</UL>
<LI>Font support:</LI><UL>
    <LI>Support for bitmapped fonts and antialiased fonts</LI>
    <LI>UTF-8 encoding</LI>
    <LI>Loadable from bitmap (similar format as Allegro)</LI>
    <LI>Allegro's TTF2PCX utility can be used to make loadable TTF fonts</LI>
    <LI>Reference counting and delete locking</LI>
</UL>

<LI>Simple mouse and keyboard support</LI>
<LI>DEGFX source compiles inside your own source code
    <UL>
    <LI>Installing/removing the library means simply copying/deleting a directory in your compilers include path</LI>
    <LI>No need to use library tools</LI>
    </UL></LI>
<LI>Currently available drivers:</LI>
<UL>
    <LI>DOS   - DJGPP VESA 2.0(linear) and VESA 1.2(banked)</LI>
    <LI>DOS   - DJGPP standard VGA (640x480x4)</LI>
    <LI>DOS   - DJGPP VGA mode 13h (320x200x8)</LI>
    <li>DOS   - Borland Turbo C++ 3.1 using BGI graphics</li>
    <LI>Linux - Svgalib *** has problems on some displays because <code>vga_setrgbcolor()</code>
    does not always function properly. ***</LI>
    <LI>Win32 - MINGW32 using GDI</LI>
    <LI>Win32 - Borlands free compiler BCC32 using GDI</LI>
    <LI>Win32 - Open Watcom target Win32 (GDI)</LI>
    <LI>Sinclair QL - QDOS *** in development ***</LI>
</UL>
<LI>Low memory requirements when using 'partial' double buffer</LI>
<LI>Buffering mode can be changed on the fly</LI>
<LI>Extremely portable: only 6 (!) platform dependant functions</LI>
<UL>
    <LI>start, stop, poll, dirty, keypress, mouse info</LI>
</UL>
<LI>Runs on almost any hardware, even my 40 MHz 386 test machine</LI>
<LI>Compiles with no changes on MSB first or LSB first hardware</LI>
<LI>Open source and GPL licence</LI>
</UL>
*/
