#define MX__DEGFX_SOURCE_LIBRARY
#include "degfx/degfx.h"

/* Basic core files -------------------------------------------------------- */
#ifndef MX__DEGFX_CORE
#   define MX__DEGFX_CORE
#   include "degfx/coregfx.c"
#   include "degfx/bitmap/bitmap.c"
#   include "degfx/bitmap/clone.c"
#   include "degfx/bitmap/clip.c"
#   include "degfx/bitmap/offset.c"
#   include "degfx/bitmap/iter.c"
#   include "degfx/bitmap/blit.c"
#   include "degfx/bitmap/blitcopy.c"
#   include "degfx/font/bitchar.c"
#   include "degfx/driver/driver.c"
#   define MX__NEWMODULE
#endif

/* DJGPP drivers */
#if defined(MX__DRIVER_DJGPP)
#   include "degfx/driver/djgpp.c"

#   if defined(MXMODULE_DRIVER_FULLSCREEN) || defined(MXMODULE_DRIVER_WINDOWED)
#      include "degfx/driver/djvesa.c"
#      define MX__NEWMODULE
#   endif
#   ifdef MXMODULE_DRIVER_VGA
#      include "degfx/driver/djvga.c"
#      define MX__NEWMODULE
#   endif
#   ifdef MXMODULE_DRIVER_13H
#      include "degfx/driver/dj13h.c"
#      define MX__NEWMODULE
#   endif

/* Win 32 drivers */
#elif defined(MX__DRIVER_WIN32_GDI)
#   include "degfx/driver/win32gdi.c"
#   define MX__NEWMODULE

/* Linux/Svgalib drivers */
#elif defined(MX__DRIVER_SVGALIB)
#   include "degfx/driver/svgalib.c"
#   define MX__NEWMODULE

/* Sinclair QL QDOS drivers */
#elif defined(MX__DRIVER_QDOS)
#   include "degfx/driver/qdos.c"
#   define MX__NEWMODULE

/* Borland Turboc C drivers */
#elif defined(MX__DRIVER_TURBOC)
#   include "degfx/driver/turboc.c"
#   define MX__NEWMODULE

/* Empty drivers */
#elif defined(MX__DRIVER_EMPTY)
#   include "degfx/driver/empty.c"
#   define MX__NEWMODULE
#endif

/* Loading modules that require support from other modules */
#ifdef MXMODULE_LOADFONT
#   ifndef MXMODULE_LOADFONT_INCLUDED
#      define MXMODULE_LOADFONT_INCLUDED
#      include "degfx/font/loadfont.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_LOADTGA
#   ifndef MXMODULE_LOADTGA_INCLUDED
#      define MXMODULE_LOADTGA_INCLUDED
#      include "degfx/bitmap/loadtga.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_LOADPCX
#   ifndef MXMODULE_LOADPCX_INCLUDED
#      define MXMODULE_LOADPCX_INCLUDED
#      include "degfx/bitmap/loadpcx.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_LOADGIF
#   ifndef MXMODULE_LOADGIF_INCLUDED
#      define MXMODULE_LOADGIF_INCLUDED
#      include "degfx/bitmap/loadgif.c"
#      define MX__NEWMODULE
#   endif
#endif

/* Bitmap related modules */
#ifdef MXMODULE_BITPIXEL
#   ifndef MXMODULE_BITPIXEL_INCLUDED
#      define MXMODULE_BITPIXEL_INCLUDED
#      include "degfx/bitmap/getpixel.c"
#      include "degfx/bitmap/pixel.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_DECORATE
#   ifndef MXMODULE_DECORATE_INCLUDED
#      define MXMODULE_DECORATE_INCLUDED
#      include "degfx/bitmap/decorate.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_BITDRAW
#   ifndef MXMODULE_BITDRAW_INCLUDED
#      define MXMODULE_BITDRAW_INCLUDED
#      include "degfx/bitmap/collisio.c"
#      include "degfx/bitmap/stretch.c"
#      include "degfx/bitmap/trans.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_BITLINE
#   ifndef MXMODULE_BITLINE_INCLUDED
#      define MXMODULE_BITLINE_INCLUDED
#      include "degfx/bitmap/vline.c"
#      include "degfx/bitmap/hline.c"
#      include "degfx/bitmap/line.c"
#      include "degfx/bitmap/rectfill.c"
#      include "degfx/bitmap/clear.c"
#      include "degfx/bitmap/box.c"
#      include "degfx/bitmap/frame.c"
#      define MX__NEWMODULE
#   endif
#endif

/* Font related modules ---------------------------------------------------- */
#ifdef MXMODULE_FONT_8X8
#   ifndef MXMODULE_FONT_8X8_INCLUDED
#      define MXMODULE_FONT_8X8_INCLUDED
#      include "degfx/font/font8x8.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_FONT_8X14
#   ifndef MXMODULE_FONT_8X14_INCLUDED
#      define MXMODULE_FONT_8X14_INCLUDED
#      include "degfx/font/font8x14.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_FONT_8X16
#   ifndef MXMODULE_FONT_8X16_INCLUDED
#      define MXMODULE_FONT_8X16_INCLUDED
#      include "degfx/font/font8x16.c"
#      define MX__NEWMODULE
#   endif
#endif

#ifdef MXMODULE_FONTDRAW
#   ifndef MXMODULE_FONTDRAW_INCLUDED
#      define MXMODULE_FONTDRAW_INCLUDED
#      include "degfx/font/fontrng.c"
#      include "degfx/font/bytechar.c"
#      include "degfx/font/fontdraw.c"
#      include "degfx/font/fontsize.c"
#      include "degfx/font/block.c"
#      define MX__NEWMODULE
#   endif
#endif

/* Supporting modules ------------------------------------------------------ */
#define MXMODULE_RECTATOM
#define MXMODULE_UTF8
#include "detk/detk.c"

/* Recursive inclusion to resolve unincluded modules */
#ifdef MX__NEWMODULE
#   undef MX__NEWMODULE
#   include "degfx/degfx.c"
#endif
