/** !The core DEGFX module

This module contains the core DEGFX functions for drawing on the
screen and gettign input from the keyboard and the mouse. */

#ifndef MX__DEGFX_CORE_HEADER
#   define MX__DEGFX_CORE_HEADER

#   include "degfx/types.h"
#   include "degfx/colors.h"
#   include "degfx/bitmap.h"
#   include "degfx/driver.h"
#   include "degfx/font.h"

#   ifdef __cplusplus
extern "C" {
#   endif
	/* System related functions */ unsigned mx_gfx_start(MX_GFX_ARGS * args);
	void mx_gfx_stop(void);
	const MX_GFX_ARGS *mx_gfx_info(void);

	void mx_gfx_save(const char *name);
	void mx_gfx_load(MX_GFX_ARGS * args, const char *name);

	/* Screen updating functions */
	void mx_gfx_redraw(MX_REDRAW_FUNC redraw);
	void mx_gfx_dirty(const MX_RECT * rect);
	unsigned mx_gfx_poll(void);

	/* Interface related functions */
	unsigned mx_gfx_pointer(int *x, int *y, int *b);
	unsigned mx_gfx_hidepointer(unsigned hide);
	unsigned mx_gfx_key(int *scan, int *ascii);

	/* Some useful macros for bitmap functions */
	extern void mx__gfx_update(MX_DRAW_FUNC draw, const MX_RECT * rect);

/** !Screen bitmap
The macro MXSCREEN can be used to specify the screen redraw buffer. */
#   define MXSCREEN (mx__args.buffer)

#   define MX_GFX_BUFFER_W 256
#   define MX_GFX_BUFFER_H 64

	/* 16 bit platforms cannot allocate more that 64k, so make the buffer smaller */
#   ifdef MX_PLATFORM_TURBOC
#      undef MX_GFX_BUFFER_W
#      undef MX_GFX_BUFFER_H
#      define MX_GFX_BUFFER_W 160
#      define MX_GFX_BUFFER_H 32
#   endif

#   ifdef __cplusplus
}
#   endif
#endif
