/** Color encoding

This module contains color encoding macros. */

#ifndef MX__DEGFX_COLORS_HEADER
#define MX__DEGFX_COLORS_HEADER

/*---------------------------------------------------------------------------*/
/* Choose *one* underlying color encoding */
/*#define MX_DEGFX_RGB332*/
/*#define MX_DEGFX_RGB555*/
#define MX_DEGFX_ARGB8888
/*---------------------------------------------------------------------------*/

#if defined(MX_DEGFX_RGB332)
#include "degfx/rgb332.h"
#elif defined(MX_DEGFX_RGB555)
#include "degfx/rgb555.h"
#elif !defined(MX_DEGFX_ARGB8888)
#define MX_DEGFX_ARGB8888
#endif

/* The default color representation */
#ifdef MX_DEGFX_ARGB8888
typedef unsigned long MX_PIXEL;

/** !Construct a pixel out of a r, g, b */
#define MXRGB(r, g, b) ((((MX_PIXEL)r) << 16) | \
                        (((MX_PIXEL)g) << 8) | \
                        (((MX_PIXEL)b)))

/** !Construct a pixel out of a r, g, b and transparency */
#define MXRGBT(r, g, b, a) ((((MX_PIXEL)a) << 24) | \
                            (((MX_PIXEL)r) << 16) | \
                            (((MX_PIXEL)g) << 8) | \
                            (((MX_PIXEL)b)))

/** !The transparency of a pixel */
#define MXT(c) (((c) >> 24) & 0xFF)

/** !Red component of a pixel */
#define MXR(c) (((c) >> 16) & 0xFF)

/** !Green component of a pixel */
#define MXG(c) (((c) >> 8) & 0xFF)

/** !Blue component of a pixel */
#define MXB(c) (((c) & 0xFF))

/** !Set pixel transparency */
#define MXTRANS(c, a) ((((MX_PIXEL)a) << 24) | ((c) & 0xFFFFFFul))

/** !Blend two pixels with transparency */
#define MXBLENDT(c1, c2, a1) \
                (((a1) >= 255) ? (c2) : (((a1) == 0) ? (c1) : \
                  (((((c1) & 0x00FF00FFul) * (256l - (a1)) + ((c2) & 0x00FF00FFul) * (a1)) & 0xFF00FF00ul) | \
                   ((((c1) & 0x0000FF00ul) * (256l - (a1)) + ((c2) & 0x0000FF00ul) * (a1)) & 0x00FF0000ul)) >> 8))

/** !Blend two pixels using the transparency component of the first pixel. */
#define MXBLEND(c1, c2) MXBLENDT((c1), (c2), MXT(c1))

#define MXRGB332(c) ((((c) & 0x00E00000ul) >> 16) | \
                     (((c) & 0x0000E000ul) >> 11) | \
                     (((c) & 0x000000C0ul) >> 6))

#define MXRGB555(c) ((((c) & 0x00F80000ul) >> 9) | \
                     (((c) & 0x0000F800ul) >> 6) | \
                     (((c) & 0x000000F8ul) >> 3))

#define MXRGB565(c) ((((c) & 0x00F80000ul) >> 8) | \
                     (((c) & 0x0000FC00ul) >> 5) | \
                     (((c) & 0x000000F8ul) >> 3))

#define MXRGB888(c) (c)
#endif

/**author MXCOLOR_* macros derived from X-windows rgb.txt. */

/** !Macros for named colors
There are many different MXCOLOR_* macros for named colors. */
#define MXCOLOR_alice MXRGB(240,248,255)
#define MXCOLOR_aliceblue MXRGB(240,248,255)
#define MXCOLOR_antique MXRGB(250,235,215)
#define MXCOLOR_antiquewhite MXRGB(250,235,215)
#define MXCOLOR_antiquewhite1 MXRGB(255,239,219)
#define MXCOLOR_antiquewhite2 MXRGB(238,223,204)
#define MXCOLOR_antiquewhite3 MXRGB(205,192,176)
#define MXCOLOR_antiquewhite4 MXRGB(139,131,120)
#define MXCOLOR_aquamarine MXRGB(50,191,193)
#define MXCOLOR_aquamarine1 MXRGB(127,255,212)
#define MXCOLOR_aquamarine2 MXRGB(118,238,198)
#define MXCOLOR_aquamarine3 MXRGB(102,205,170)
#define MXCOLOR_aquamarine4 MXRGB(69,139,116)
#define MXCOLOR_azure MXRGB(240,255,255)
#define MXCOLOR_azure1 MXRGB(240,255,255)
#define MXCOLOR_azure2 MXRGB(224,238,238)
#define MXCOLOR_azure3 MXRGB(193,205,205)
#define MXCOLOR_azure4 MXRGB(131,139,139)
#define MXCOLOR_beige MXRGB(245,245,220)
#define MXCOLOR_bisque MXRGB(255,228,196)
#define MXCOLOR_bisque1 MXRGB(255,228,196)
#define MXCOLOR_bisque2 MXRGB(238,213,183)
#define MXCOLOR_bisque3 MXRGB(205,183,158)
#define MXCOLOR_bisque4 MXRGB(139,125,107)
#define MXCOLOR_black MXRGB(0,0,0)
#define MXCOLOR_blanched MXRGB(255,235,205)
#define MXCOLOR_blanchedalmond MXRGB(255,235,205)
#define MXCOLOR_blue MXRGB(0,0,255)
#define MXCOLOR_blue1 MXRGB(0,0,255)
#define MXCOLOR_blue2 MXRGB(0,0,238)
#define MXCOLOR_blue3 MXRGB(0,0,205)
#define MXCOLOR_blue4 MXRGB(0,0,139)
#define MXCOLOR_blueviolet MXRGB(138,43,226)
#define MXCOLOR_brown MXRGB(165,42,42)
#define MXCOLOR_brown1 MXRGB(255,64,64)
#define MXCOLOR_brown2 MXRGB(238,59,59)
#define MXCOLOR_brown3 MXRGB(205,51,51)
#define MXCOLOR_brown4 MXRGB(139,35,35)
#define MXCOLOR_burlywood MXRGB(222,184,135)
#define MXCOLOR_burlywood1 MXRGB(255,211,155)
#define MXCOLOR_burlywood2 MXRGB(238,197,145)
#define MXCOLOR_burlywood3 MXRGB(205,170,125)
#define MXCOLOR_burlywood4 MXRGB(139,115,85)
#define MXCOLOR_cadet MXRGB(95,146,158)
#define MXCOLOR_cadetblue MXRGB(95,146,158)
#define MXCOLOR_cadetblue1 MXRGB(152,245,255)
#define MXCOLOR_cadetblue2 MXRGB(142,229,238)
#define MXCOLOR_cadetblue3 MXRGB(122,197,205)
#define MXCOLOR_cadetblue4 MXRGB(83,134,139)
#define MXCOLOR_chartreuse MXRGB(127,255,0)
#define MXCOLOR_chartreuse1 MXRGB(127,255,0)
#define MXCOLOR_chartreuse2 MXRGB(118,238,0)
#define MXCOLOR_chartreuse3 MXRGB(102,205,0)
#define MXCOLOR_chartreuse4 MXRGB(69,139,0)
#define MXCOLOR_chocolate MXRGB(210,105,30)
#define MXCOLOR_chocolate1 MXRGB(255,127,36)
#define MXCOLOR_chocolate2 MXRGB(238,118,33)
#define MXCOLOR_chocolate3 MXRGB(205,102,29)
#define MXCOLOR_chocolate4 MXRGB(139,69,19)
#define MXCOLOR_coral MXRGB(255,114,86)
#define MXCOLOR_coral1 MXRGB(255,114,86)
#define MXCOLOR_coral2 MXRGB(238,106,80)
#define MXCOLOR_coral3 MXRGB(205,91,69)
#define MXCOLOR_coral4 MXRGB(139,62,47)
#define MXCOLOR_cornflower MXRGB(34,34,152)
#define MXCOLOR_cornflowerblue MXRGB(34,34,152)
#define MXCOLOR_cornsilk MXRGB(255,248,220)
#define MXCOLOR_cornsilk1 MXRGB(255,248,220)
#define MXCOLOR_cornsilk2 MXRGB(238,232,205)
#define MXCOLOR_cornsilk3 MXRGB(205,200,177)
#define MXCOLOR_cornsilk4 MXRGB(139,136,120)
#define MXCOLOR_cyan MXRGB(0,255,255)
#define MXCOLOR_cyan1 MXRGB(0,255,255)
#define MXCOLOR_cyan2 MXRGB(0,238,238)
#define MXCOLOR_cyan3 MXRGB(0,205,205)
#define MXCOLOR_cyan4 MXRGB(0,139,139)
#define MXCOLOR_dark MXRGB(189,183,107)
#define MXCOLOR_darkgoldenrod MXRGB(184,134,11)
#define MXCOLOR_darkgoldenrod1 MXRGB(255,185,15)
#define MXCOLOR_darkgoldenrod2 MXRGB(238,173,14)
#define MXCOLOR_darkgoldenrod3 MXRGB(205,149,12)
#define MXCOLOR_darkgoldenrod4 MXRGB(139,101,8)
#define MXCOLOR_darkgreen MXRGB(0,86,45)
#define MXCOLOR_darkkhaki MXRGB(189,183,107)
#define MXCOLOR_darknessy MXRGB(222,0,165)
#define MXCOLOR_darkolivegreen MXRGB(85,86,47)
#define MXCOLOR_darkolivegreen1 MXRGB(202,255,112)
#define MXCOLOR_darkolivegreen2 MXRGB(188,238,104)
#define MXCOLOR_darkolivegreen3 MXRGB(162,205,90)
#define MXCOLOR_darkolivegreen4 MXRGB(110,139,61)
#define MXCOLOR_darkorange MXRGB(255,140,0)
#define MXCOLOR_darkorange1 MXRGB(255,127,0)
#define MXCOLOR_darkorange2 MXRGB(238,118,0)
#define MXCOLOR_darkorange3 MXRGB(205,102,0)
#define MXCOLOR_darkorange4 MXRGB(139,69,0)
#define MXCOLOR_darkorchid MXRGB(139,32,139)
#define MXCOLOR_darkorchid1 MXRGB(191,62,255)
#define MXCOLOR_darkorchid2 MXRGB(178,58,238)
#define MXCOLOR_darkorchid3 MXRGB(154,50,205)
#define MXCOLOR_darkorchid4 MXRGB(104,34,139)
#define MXCOLOR_darksalmon MXRGB(233,150,122)
#define MXCOLOR_darkseagreen MXRGB(143,188,143)
#define MXCOLOR_darkseagreen1 MXRGB(193,255,193)
#define MXCOLOR_darkseagreen2 MXRGB(180,238,180)
#define MXCOLOR_darkseagreen3 MXRGB(155,205,155)
#define MXCOLOR_darkseagreen4 MXRGB(105,139,105)
#define MXCOLOR_darkslateblue MXRGB(56,75,102)
#define MXCOLOR_darkslategray MXRGB(47,79,79)
#define MXCOLOR_darkslategray1 MXRGB(151,255,255)
#define MXCOLOR_darkslategray2 MXRGB(141,238,238)
#define MXCOLOR_darkslategray3 MXRGB(121,205,205)
#define MXCOLOR_darkslategray4 MXRGB(82,139,139)
#define MXCOLOR_darkslategrey MXRGB(47,79,79)
#define MXCOLOR_darkturquoise MXRGB(0,166,166)
#define MXCOLOR_darkviolet MXRGB(148,0,211)
#define MXCOLOR_deep MXRGB(255,20,147)
#define MXCOLOR_deeppink MXRGB(255,20,147)
#define MXCOLOR_deeppink1 MXRGB(255,20,147)
#define MXCOLOR_deeppink2 MXRGB(238,18,137)
#define MXCOLOR_deeppink3 MXRGB(205,16,118)
#define MXCOLOR_deeppink4 MXRGB(139,10,80)
#define MXCOLOR_deepskyblue MXRGB(0,191,255)
#define MXCOLOR_deepskyblue1 MXRGB(0,191,255)
#define MXCOLOR_deepskyblue2 MXRGB(0,178,238)
#define MXCOLOR_deepskyblue3 MXRGB(0,154,205)
#define MXCOLOR_deepskyblue4 MXRGB(0,104,139)
#define MXCOLOR_dim MXRGB(84,84,84)
#define MXCOLOR_dimgray MXRGB(84,84,84)
#define MXCOLOR_dimgrey MXRGB(84,84,84)
#define MXCOLOR_dodger MXRGB(30,144,255)
#define MXCOLOR_dodgerblue MXRGB(30,144,255)
#define MXCOLOR_dodgerblue1 MXRGB(30,144,255)
#define MXCOLOR_dodgerblue2 MXRGB(28,134,238)
#define MXCOLOR_dodgerblue3 MXRGB(24,116,205)
#define MXCOLOR_dodgerblue4 MXRGB(16,78,139)
#define MXCOLOR_firebrick MXRGB(142,35,35)
#define MXCOLOR_firebrick1 MXRGB(255,48,48)
#define MXCOLOR_firebrick2 MXRGB(238,44,44)
#define MXCOLOR_firebrick3 MXRGB(205,38,38)
#define MXCOLOR_firebrick4 MXRGB(139,26,26)
#define MXCOLOR_floral MXRGB(255,250,240)
#define MXCOLOR_floralwhite MXRGB(255,250,240)
#define MXCOLOR_forest MXRGB(80,159,105)
#define MXCOLOR_forestgreen MXRGB(80,159,105)
#define MXCOLOR_gainsboro MXRGB(220,220,220)
#define MXCOLOR_ghost MXRGB(248,248,255)
#define MXCOLOR_ghostwhite MXRGB(248,248,255)
#define MXCOLOR_gold MXRGB(218,170,0)
#define MXCOLOR_gold1 MXRGB(255,215,0)
#define MXCOLOR_gold2 MXRGB(238,201,0)
#define MXCOLOR_gold3 MXRGB(205,173,0)
#define MXCOLOR_gold4 MXRGB(139,117,0)
#define MXCOLOR_goldenrod MXRGB(239,223,132)
#define MXCOLOR_goldenrod1 MXRGB(255,193,37)
#define MXCOLOR_goldenrod2 MXRGB(238,180,34)
#define MXCOLOR_goldenrod3 MXRGB(205,155,29)
#define MXCOLOR_goldenrod4 MXRGB(139,105,20)
#define MXCOLOR_gray MXRGB(126,126,126)
#define MXCOLOR_gray0 MXRGB(0,0,0)
#define MXCOLOR_gray1 MXRGB(3,3,3)
#define MXCOLOR_gray10 MXRGB(26,26,26)
#define MXCOLOR_gray100 MXRGB(255,255,255)
#define MXCOLOR_gray11 MXRGB(28,28,28)
#define MXCOLOR_gray12 MXRGB(31,31,31)
#define MXCOLOR_gray13 MXRGB(33,33,33)
#define MXCOLOR_gray14 MXRGB(36,36,36)
#define MXCOLOR_gray15 MXRGB(38,38,38)
#define MXCOLOR_gray16 MXRGB(41,41,41)
#define MXCOLOR_gray17 MXRGB(43,43,43)
#define MXCOLOR_gray18 MXRGB(46,46,46)
#define MXCOLOR_gray19 MXRGB(48,48,48)
#define MXCOLOR_gray2 MXRGB(5,5,5)
#define MXCOLOR_gray20 MXRGB(51,51,51)
#define MXCOLOR_gray21 MXRGB(54,54,54)
#define MXCOLOR_gray22 MXRGB(56,56,56)
#define MXCOLOR_gray23 MXRGB(59,59,59)
#define MXCOLOR_gray24 MXRGB(61,61,61)
#define MXCOLOR_gray25 MXRGB(64,64,64)
#define MXCOLOR_gray26 MXRGB(66,66,66)
#define MXCOLOR_gray27 MXRGB(69,69,69)
#define MXCOLOR_gray28 MXRGB(71,71,71)
#define MXCOLOR_gray29 MXRGB(74,74,74)
#define MXCOLOR_gray3 MXRGB(8,8,8)
#define MXCOLOR_gray30 MXRGB(77,77,77)
#define MXCOLOR_gray31 MXRGB(79,79,79)
#define MXCOLOR_gray32 MXRGB(82,82,82)
#define MXCOLOR_gray33 MXRGB(84,84,84)
#define MXCOLOR_gray34 MXRGB(87,87,87)
#define MXCOLOR_gray35 MXRGB(89,89,89)
#define MXCOLOR_gray36 MXRGB(92,92,92)
#define MXCOLOR_gray37 MXRGB(94,94,94)
#define MXCOLOR_gray38 MXRGB(97,97,97)
#define MXCOLOR_gray39 MXRGB(99,99,99)
#define MXCOLOR_gray4 MXRGB(10,10,10)
#define MXCOLOR_gray40 MXRGB(102,102,102)
#define MXCOLOR_gray41 MXRGB(105,105,105)
#define MXCOLOR_gray42 MXRGB(107,107,107)
#define MXCOLOR_gray43 MXRGB(110,110,110)
#define MXCOLOR_gray44 MXRGB(112,112,112)
#define MXCOLOR_gray45 MXRGB(115,115,115)
#define MXCOLOR_gray46 MXRGB(117,117,117)
#define MXCOLOR_gray47 MXRGB(120,120,120)
#define MXCOLOR_gray48 MXRGB(122,122,122)
#define MXCOLOR_gray49 MXRGB(125,125,125)
#define MXCOLOR_gray5 MXRGB(13,13,13)
#define MXCOLOR_gray50 MXRGB(127,127,127)
#define MXCOLOR_gray51 MXRGB(130,130,130)
#define MXCOLOR_gray52 MXRGB(133,133,133)
#define MXCOLOR_gray53 MXRGB(135,135,135)
#define MXCOLOR_gray54 MXRGB(138,138,138)
#define MXCOLOR_gray55 MXRGB(140,140,140)
#define MXCOLOR_gray56 MXRGB(143,143,143)
#define MXCOLOR_gray57 MXRGB(145,145,145)
#define MXCOLOR_gray58 MXRGB(148,148,148)
#define MXCOLOR_gray59 MXRGB(150,150,150)
#define MXCOLOR_gray6 MXRGB(15,15,15)
#define MXCOLOR_gray60 MXRGB(153,153,153)
#define MXCOLOR_gray61 MXRGB(156,156,156)
#define MXCOLOR_gray62 MXRGB(158,158,158)
#define MXCOLOR_gray63 MXRGB(161,161,161)
#define MXCOLOR_gray64 MXRGB(163,163,163)
#define MXCOLOR_gray65 MXRGB(166,166,166)
#define MXCOLOR_gray66 MXRGB(168,168,168)
#define MXCOLOR_gray67 MXRGB(171,171,171)
#define MXCOLOR_gray68 MXRGB(173,173,173)
#define MXCOLOR_gray69 MXRGB(176,176,176)
#define MXCOLOR_gray7 MXRGB(18,18,18)
#define MXCOLOR_gray70 MXRGB(179,179,179)
#define MXCOLOR_gray71 MXRGB(181,181,181)
#define MXCOLOR_gray72 MXRGB(184,184,184)
#define MXCOLOR_gray73 MXRGB(186,186,186)
#define MXCOLOR_gray74 MXRGB(189,189,189)
#define MXCOLOR_gray75 MXRGB(191,191,191)
#define MXCOLOR_gray76 MXRGB(194,194,194)
#define MXCOLOR_gray77 MXRGB(196,196,196)
#define MXCOLOR_gray78 MXRGB(199,199,199)
#define MXCOLOR_gray79 MXRGB(201,201,201)
#define MXCOLOR_gray8 MXRGB(20,20,20)
#define MXCOLOR_gray80 MXRGB(204,204,204)
#define MXCOLOR_gray81 MXRGB(207,207,207)
#define MXCOLOR_gray82 MXRGB(209,209,209)
#define MXCOLOR_gray83 MXRGB(212,212,212)
#define MXCOLOR_gray84 MXRGB(214,214,214)
#define MXCOLOR_gray85 MXRGB(217,217,217)
#define MXCOLOR_gray86 MXRGB(219,219,219)
#define MXCOLOR_gray87 MXRGB(222,222,222)
#define MXCOLOR_gray88 MXRGB(224,224,224)
#define MXCOLOR_gray89 MXRGB(227,227,227)
#define MXCOLOR_gray9 MXRGB(23,23,23)
#define MXCOLOR_gray90 MXRGB(229,229,229)
#define MXCOLOR_gray91 MXRGB(232,232,232)
#define MXCOLOR_gray92 MXRGB(235,235,235)
#define MXCOLOR_gray93 MXRGB(237,237,237)
#define MXCOLOR_gray94 MXRGB(240,240,240)
#define MXCOLOR_gray95 MXRGB(242,242,242)
#define MXCOLOR_gray96 MXRGB(245,245,245)
#define MXCOLOR_gray97 MXRGB(247,247,247)
#define MXCOLOR_gray98 MXRGB(250,250,250)
#define MXCOLOR_gray99 MXRGB(252,252,252)
#define MXCOLOR_green MXRGB(0,255,0)
#define MXCOLOR_green1 MXRGB(0,255,0)
#define MXCOLOR_green2 MXRGB(0,238,0)
#define MXCOLOR_green3 MXRGB(0,205,0)
#define MXCOLOR_green4 MXRGB(0,139,0)
#define MXCOLOR_greenyellow MXRGB(173,255,47)
#define MXCOLOR_grey MXRGB(126,126,126)
#define MXCOLOR_grey0 MXRGB(0,0,0)
#define MXCOLOR_grey1 MXRGB(3,3,3)
#define MXCOLOR_grey10 MXRGB(26,26,26)
#define MXCOLOR_grey100 MXRGB(255,255,255)
#define MXCOLOR_grey11 MXRGB(28,28,28)
#define MXCOLOR_grey12 MXRGB(31,31,31)
#define MXCOLOR_grey13 MXRGB(33,33,33)
#define MXCOLOR_grey14 MXRGB(36,36,36)
#define MXCOLOR_grey15 MXRGB(38,38,38)
#define MXCOLOR_grey16 MXRGB(41,41,41)
#define MXCOLOR_grey17 MXRGB(43,43,43)
#define MXCOLOR_grey18 MXRGB(46,46,46)
#define MXCOLOR_grey19 MXRGB(48,48,48)
#define MXCOLOR_grey2 MXRGB(5,5,5)
#define MXCOLOR_grey20 MXRGB(51,51,51)
#define MXCOLOR_grey21 MXRGB(54,54,54)
#define MXCOLOR_grey22 MXRGB(56,56,56)
#define MXCOLOR_grey23 MXRGB(59,59,59)
#define MXCOLOR_grey24 MXRGB(61,61,61)
#define MXCOLOR_grey25 MXRGB(64,64,64)
#define MXCOLOR_grey26 MXRGB(66,66,66)
#define MXCOLOR_grey27 MXRGB(69,69,69)
#define MXCOLOR_grey28 MXRGB(71,71,71)
#define MXCOLOR_grey29 MXRGB(74,74,74)
#define MXCOLOR_grey3 MXRGB(8,8,8)
#define MXCOLOR_grey30 MXRGB(77,77,77)
#define MXCOLOR_grey31 MXRGB(79,79,79)
#define MXCOLOR_grey32 MXRGB(82,82,82)
#define MXCOLOR_grey33 MXRGB(84,84,84)
#define MXCOLOR_grey34 MXRGB(87,87,87)
#define MXCOLOR_grey35 MXRGB(89,89,89)
#define MXCOLOR_grey36 MXRGB(92,92,92)
#define MXCOLOR_grey37 MXRGB(94,94,94)
#define MXCOLOR_grey38 MXRGB(97,97,97)
#define MXCOLOR_grey39 MXRGB(99,99,99)
#define MXCOLOR_grey4 MXRGB(10,10,10)
#define MXCOLOR_grey40 MXRGB(102,102,102)
#define MXCOLOR_grey41 MXRGB(105,105,105)
#define MXCOLOR_grey42 MXRGB(107,107,107)
#define MXCOLOR_grey43 MXRGB(110,110,110)
#define MXCOLOR_grey44 MXRGB(112,112,112)
#define MXCOLOR_grey45 MXRGB(115,115,115)
#define MXCOLOR_grey46 MXRGB(117,117,117)
#define MXCOLOR_grey47 MXRGB(120,120,120)
#define MXCOLOR_grey48 MXRGB(122,122,122)
#define MXCOLOR_grey49 MXRGB(125,125,125)
#define MXCOLOR_grey5 MXRGB(13,13,13)
#define MXCOLOR_grey50 MXRGB(127,127,127)
#define MXCOLOR_grey51 MXRGB(130,130,130)
#define MXCOLOR_grey52 MXRGB(133,133,133)
#define MXCOLOR_grey53 MXRGB(135,135,135)
#define MXCOLOR_grey54 MXRGB(138,138,138)
#define MXCOLOR_grey55 MXRGB(140,140,140)
#define MXCOLOR_grey56 MXRGB(143,143,143)
#define MXCOLOR_grey57 MXRGB(145,145,145)
#define MXCOLOR_grey58 MXRGB(148,148,148)
#define MXCOLOR_grey59 MXRGB(150,150,150)
#define MXCOLOR_grey6 MXRGB(15,15,15)
#define MXCOLOR_grey60 MXRGB(153,153,153)
#define MXCOLOR_grey61 MXRGB(156,156,156)
#define MXCOLOR_grey62 MXRGB(158,158,158)
#define MXCOLOR_grey63 MXRGB(161,161,161)
#define MXCOLOR_grey64 MXRGB(163,163,163)
#define MXCOLOR_grey65 MXRGB(166,166,166)
#define MXCOLOR_grey66 MXRGB(168,168,168)
#define MXCOLOR_grey67 MXRGB(171,171,171)
#define MXCOLOR_grey68 MXRGB(173,173,173)
#define MXCOLOR_grey69 MXRGB(176,176,176)
#define MXCOLOR_grey7 MXRGB(18,18,18)
#define MXCOLOR_grey70 MXRGB(179,179,179)
#define MXCOLOR_grey71 MXRGB(181,181,181)
#define MXCOLOR_grey72 MXRGB(184,184,184)
#define MXCOLOR_grey73 MXRGB(186,186,186)
#define MXCOLOR_grey74 MXRGB(189,189,189)
#define MXCOLOR_grey75 MXRGB(191,191,191)
#define MXCOLOR_grey76 MXRGB(194,194,194)
#define MXCOLOR_grey77 MXRGB(196,196,196)
#define MXCOLOR_grey78 MXRGB(199,199,199)
#define MXCOLOR_grey79 MXRGB(201,201,201)
#define MXCOLOR_grey8 MXRGB(20,20,20)
#define MXCOLOR_grey80 MXRGB(204,204,204)
#define MXCOLOR_grey81 MXRGB(207,207,207)
#define MXCOLOR_grey82 MXRGB(209,209,209)
#define MXCOLOR_grey83 MXRGB(212,212,212)
#define MXCOLOR_grey84 MXRGB(214,214,214)
#define MXCOLOR_grey85 MXRGB(217,217,217)
#define MXCOLOR_grey86 MXRGB(219,219,219)
#define MXCOLOR_grey87 MXRGB(222,222,222)
#define MXCOLOR_grey88 MXRGB(224,224,224)
#define MXCOLOR_grey89 MXRGB(227,227,227)
#define MXCOLOR_grey9 MXRGB(23,23,23)
#define MXCOLOR_grey90 MXRGB(229,229,229)
#define MXCOLOR_grey91 MXRGB(232,232,232)
#define MXCOLOR_grey92 MXRGB(235,235,235)
#define MXCOLOR_grey93 MXRGB(237,237,237)
#define MXCOLOR_grey94 MXRGB(240,240,240)
#define MXCOLOR_grey95 MXRGB(242,242,242)
#define MXCOLOR_grey96 MXRGB(245,245,245)
#define MXCOLOR_grey97 MXRGB(247,247,247)
#define MXCOLOR_grey98 MXRGB(250,250,250)
#define MXCOLOR_grey99 MXRGB(252,252,252)
#define MXCOLOR_honeydew MXRGB(240,255,240)
#define MXCOLOR_honeydew1 MXRGB(240,255,240)
#define MXCOLOR_honeydew2 MXRGB(224,238,224)
#define MXCOLOR_honeydew3 MXRGB(193,205,193)
#define MXCOLOR_honeydew4 MXRGB(131,139,131)
#define MXCOLOR_hot MXRGB(255,105,180)
#define MXCOLOR_hotpink MXRGB(255,105,180)
#define MXCOLOR_hotpink1 MXRGB(255,110,180)
#define MXCOLOR_hotpink2 MXRGB(238,106,167)
#define MXCOLOR_hotpink3 MXRGB(205,96,144)
#define MXCOLOR_hotpink4 MXRGB(139,58,98)
#define MXCOLOR_indian MXRGB(107,57,57)
#define MXCOLOR_indianred MXRGB(107,57,57)
#define MXCOLOR_indianred1 MXRGB(255,106,106)
#define MXCOLOR_indianred2 MXRGB(238,99,99)
#define MXCOLOR_indianred3 MXRGB(205,85,85)
#define MXCOLOR_indianred4 MXRGB(139,58,58)
#define MXCOLOR_ivory MXRGB(255,255,240)
#define MXCOLOR_ivory1 MXRGB(255,255,240)
#define MXCOLOR_ivory2 MXRGB(238,238,224)
#define MXCOLOR_ivory3 MXRGB(205,205,193)
#define MXCOLOR_ivory4 MXRGB(139,139,131)
#define MXCOLOR_khaki MXRGB(179,179,126)
#define MXCOLOR_khaki1 MXRGB(255,246,143)
#define MXCOLOR_khaki2 MXRGB(238,230,133)
#define MXCOLOR_khaki3 MXRGB(205,198,115)
#define MXCOLOR_khaki4 MXRGB(139,134,78)
#define MXCOLOR_lavender MXRGB(230,230,250)
#define MXCOLOR_lavenderblush MXRGB(255,240,245)
#define MXCOLOR_lavenderblush1 MXRGB(255,240,245)
#define MXCOLOR_lavenderblush2 MXRGB(238,224,229)
#define MXCOLOR_lavenderblush3 MXRGB(205,193,197)
#define MXCOLOR_lavenderblush4 MXRGB(139,131,134)
#define MXCOLOR_lawn MXRGB(124,252,0)
#define MXCOLOR_lawngreen MXRGB(124,252,0)
#define MXCOLOR_lemon MXRGB(255,250,205)
#define MXCOLOR_lemonchiffon MXRGB(255,250,205)
#define MXCOLOR_lemonchiffon1 MXRGB(255,250,205)
#define MXCOLOR_lemonchiffon2 MXRGB(238,233,191)
#define MXCOLOR_lemonchiffon3 MXRGB(205,201,165)
#define MXCOLOR_lemonchiffon4 MXRGB(139,137,112)
#define MXCOLOR_light MXRGB(240,128,128)
#define MXCOLOR_lightblue MXRGB(176,226,255)
#define MXCOLOR_lightblue1 MXRGB(191,239,255)
#define MXCOLOR_lightblue2 MXRGB(178,223,238)
#define MXCOLOR_lightblue3 MXRGB(154,192,205)
#define MXCOLOR_lightblue4 MXRGB(104,131,139)
#define MXCOLOR_lightcoral MXRGB(240,128,128)
#define MXCOLOR_lightcyan MXRGB(224,255,255)
#define MXCOLOR_lightcyan1 MXRGB(224,255,255)
#define MXCOLOR_lightcyan2 MXRGB(209,238,238)
#define MXCOLOR_lightcyan3 MXRGB(180,205,205)
#define MXCOLOR_lightcyan4 MXRGB(122,139,139)
#define MXCOLOR_lightgoldenrod MXRGB(238,221,130)
#define MXCOLOR_lightgoldenrod1 MXRGB(255,236,139)
#define MXCOLOR_lightgoldenrod2 MXRGB(238,220,130)
#define MXCOLOR_lightgoldenrod3 MXRGB(205,190,112)
#define MXCOLOR_lightgoldenrod4 MXRGB(139,129,76)
#define MXCOLOR_lightgoldenrodyellow MXRGB(250,250,210)
#define MXCOLOR_lightgray MXRGB(168,168,168)
#define MXCOLOR_lightgrey MXRGB(168,168,168)
#define MXCOLOR_lightnessy MXRGB(255,128,210)
#define MXCOLOR_lightpink MXRGB(255,182,193)
#define MXCOLOR_lightpink1 MXRGB(255,174,185)
#define MXCOLOR_lightpink2 MXRGB(238,162,173)
#define MXCOLOR_lightpink3 MXRGB(205,140,149)
#define MXCOLOR_lightpink4 MXRGB(139,95,101)
#define MXCOLOR_lightsalmon MXRGB(255,160,122)
#define MXCOLOR_lightsalmon1 MXRGB(255,160,122)
#define MXCOLOR_lightsalmon2 MXRGB(238,149,114)
#define MXCOLOR_lightsalmon3 MXRGB(205,129,98)
#define MXCOLOR_lightsalmon4 MXRGB(139,87,66)
#define MXCOLOR_lightseagreen MXRGB(32,178,170)
#define MXCOLOR_lightskyblue MXRGB(135,206,250)
#define MXCOLOR_lightskyblue1 MXRGB(176,226,255)
#define MXCOLOR_lightskyblue2 MXRGB(164,211,238)
#define MXCOLOR_lightskyblue3 MXRGB(141,182,205)
#define MXCOLOR_lightskyblue4 MXRGB(96,123,139)
#define MXCOLOR_lightslateblue MXRGB(132,112,255)
#define MXCOLOR_lightslategray MXRGB(119,136,153)
#define MXCOLOR_lightslategrey MXRGB(119,136,153)
#define MXCOLOR_lightsteelblue MXRGB(124,152,211)
#define MXCOLOR_lightsteelblue1 MXRGB(202,225,255)
#define MXCOLOR_lightsteelblue2 MXRGB(188,210,238)
#define MXCOLOR_lightsteelblue3 MXRGB(162,181,205)
#define MXCOLOR_lightsteelblue4 MXRGB(110,123,139)
#define MXCOLOR_lightyellow MXRGB(255,255,224)
#define MXCOLOR_lightyellow1 MXRGB(255,255,224)
#define MXCOLOR_lightyellow2 MXRGB(238,238,209)
#define MXCOLOR_lightyellow3 MXRGB(205,205,180)
#define MXCOLOR_lightyellow4 MXRGB(139,139,122)
#define MXCOLOR_lime MXRGB(0,175,20)
#define MXCOLOR_limegreen MXRGB(0,175,20)
#define MXCOLOR_linen MXRGB(250,240,230)
#define MXCOLOR_magenta MXRGB(255,0,255)
#define MXCOLOR_magenta1 MXRGB(255,0,255)
#define MXCOLOR_magenta2 MXRGB(238,0,238)
#define MXCOLOR_magenta3 MXRGB(205,0,205)
#define MXCOLOR_magenta4 MXRGB(139,0,139)
#define MXCOLOR_maroon MXRGB(143,0,82)
#define MXCOLOR_maroon1 MXRGB(255,52,179)
#define MXCOLOR_maroon2 MXRGB(238,48,167)
#define MXCOLOR_maroon3 MXRGB(205,41,144)
#define MXCOLOR_maroon4 MXRGB(139,28,98)
#define MXCOLOR_medium MXRGB(209,193,102)
#define MXCOLOR_mediumaquamarine MXRGB(0,147,143)
#define MXCOLOR_mediumblue MXRGB(50,50,204)
#define MXCOLOR_mediumforestgreen MXRGB(50,129,75)
#define MXCOLOR_mediumgoldenrod MXRGB(209,193,102)
#define MXCOLOR_mediumorchid MXRGB(189,82,189)
#define MXCOLOR_mediumorchid1 MXRGB(224,102,255)
#define MXCOLOR_mediumorchid2 MXRGB(209,95,238)
#define MXCOLOR_mediumorchid3 MXRGB(180,82,205)
#define MXCOLOR_mediumorchid4 MXRGB(122,55,139)
#define MXCOLOR_mediumpurple MXRGB(147,112,219)
#define MXCOLOR_mediumpurple1 MXRGB(171,130,255)
#define MXCOLOR_mediumpurple2 MXRGB(159,121,238)
#define MXCOLOR_mediumpurple3 MXRGB(137,104,205)
#define MXCOLOR_mediumpurple4 MXRGB(93,71,139)
#define MXCOLOR_mediumseagreen MXRGB(52,119,102)
#define MXCOLOR_mediumslateblue MXRGB(106,106,141)
#define MXCOLOR_mediumspringgreen MXRGB(35,142,35)
#define MXCOLOR_mediumturquoise MXRGB(0,210,210)
#define MXCOLOR_mediumvioletred MXRGB(213,32,121)
#define MXCOLOR_midnight MXRGB(47,47,100)
#define MXCOLOR_midnightblue MXRGB(47,47,100)
#define MXCOLOR_mint MXRGB(245,255,250)
#define MXCOLOR_mintcream MXRGB(245,255,250)
#define MXCOLOR_misty MXRGB(255,228,225)
#define MXCOLOR_mistyrose MXRGB(255,228,225)
#define MXCOLOR_mistyrose1 MXRGB(255,228,225)
#define MXCOLOR_mistyrose2 MXRGB(238,213,210)
#define MXCOLOR_mistyrose3 MXRGB(205,183,181)
#define MXCOLOR_mistyrose4 MXRGB(139,125,123)
#define MXCOLOR_moccasin MXRGB(255,228,181)
#define MXCOLOR_navajo MXRGB(255,222,173)
#define MXCOLOR_navajowhite MXRGB(255,222,173)
#define MXCOLOR_navajowhite1 MXRGB(255,222,173)
#define MXCOLOR_navajowhite2 MXRGB(238,207,161)
#define MXCOLOR_navajowhite3 MXRGB(205,179,139)
#define MXCOLOR_navajowhite4 MXRGB(139,121,94)
#define MXCOLOR_navy MXRGB(35,35,117)
#define MXCOLOR_navyblue MXRGB(35,35,117)
#define MXCOLOR_nessy MXRGB(255,66,210)
#define MXCOLOR_old MXRGB(253,245,230)
#define MXCOLOR_oldlace MXRGB(253,245,230)
#define MXCOLOR_olive MXRGB(107,142,35)
#define MXCOLOR_olivedrab MXRGB(107,142,35)
#define MXCOLOR_olivedrab1 MXRGB(192,255,62)
#define MXCOLOR_olivedrab2 MXRGB(179,238,58)
#define MXCOLOR_olivedrab3 MXRGB(154,205,50)
#define MXCOLOR_olivedrab4 MXRGB(105,139,34)
#define MXCOLOR_orange MXRGB(255,135,0)
#define MXCOLOR_orange1 MXRGB(255,165,0)
#define MXCOLOR_orange2 MXRGB(238,154,0)
#define MXCOLOR_orange3 MXRGB(205,133,0)
#define MXCOLOR_orange4 MXRGB(139,90,0)
#define MXCOLOR_orangered MXRGB(255,69,0)
#define MXCOLOR_orangered1 MXRGB(255,69,0)
#define MXCOLOR_orangered2 MXRGB(238,64,0)
#define MXCOLOR_orangered3 MXRGB(205,55,0)
#define MXCOLOR_orangered4 MXRGB(139,37,0)
#define MXCOLOR_orchid MXRGB(239,132,239)
#define MXCOLOR_orchid1 MXRGB(255,131,250)
#define MXCOLOR_orchid2 MXRGB(238,122,233)
#define MXCOLOR_orchid3 MXRGB(205,105,201)
#define MXCOLOR_orchid4 MXRGB(139,71,137)
#define MXCOLOR_pale MXRGB(115,222,120)
#define MXCOLOR_palegoldenrod MXRGB(238,232,170)
#define MXCOLOR_palegreen MXRGB(115,222,120)
#define MXCOLOR_palegreen1 MXRGB(154,255,154)
#define MXCOLOR_palegreen2 MXRGB(144,238,144)
#define MXCOLOR_palegreen3 MXRGB(124,205,124)
#define MXCOLOR_palegreen4 MXRGB(84,139,84)
#define MXCOLOR_paleturquoise MXRGB(175,238,238)
#define MXCOLOR_paleturquoise1 MXRGB(187,255,255)
#define MXCOLOR_paleturquoise2 MXRGB(174,238,238)
#define MXCOLOR_paleturquoise3 MXRGB(150,205,205)
#define MXCOLOR_paleturquoise4 MXRGB(102,139,139)
#define MXCOLOR_palevioletred MXRGB(219,112,147)
#define MXCOLOR_palevioletred1 MXRGB(255,130,171)
#define MXCOLOR_palevioletred2 MXRGB(238,121,159)
#define MXCOLOR_palevioletred3 MXRGB(205,104,137)
#define MXCOLOR_palevioletred4 MXRGB(139,71,93)
#define MXCOLOR_papaya MXRGB(255,239,213)
#define MXCOLOR_papayawhip MXRGB(255,239,213)
#define MXCOLOR_peach MXRGB(255,218,185)
#define MXCOLOR_peachpuff MXRGB(255,218,185)
#define MXCOLOR_peachpuff1 MXRGB(255,218,185)
#define MXCOLOR_peachpuff2 MXRGB(238,203,173)
#define MXCOLOR_peachpuff3 MXRGB(205,175,149)
#define MXCOLOR_peachpuff4 MXRGB(139,119,101)
#define MXCOLOR_peru MXRGB(205,133,63)
#define MXCOLOR_pink MXRGB(255,181,197)
#define MXCOLOR_pink1 MXRGB(255,181,197)
#define MXCOLOR_pink2 MXRGB(238,169,184)
#define MXCOLOR_pink3 MXRGB(205,145,158)
#define MXCOLOR_pink4 MXRGB(139,99,108)
#define MXCOLOR_plum MXRGB(197,72,155)
#define MXCOLOR_plum1 MXRGB(255,187,255)
#define MXCOLOR_plum2 MXRGB(238,174,238)
#define MXCOLOR_plum3 MXRGB(205,150,205)
#define MXCOLOR_plum4 MXRGB(139,102,139)
#define MXCOLOR_powder MXRGB(176,224,230)
#define MXCOLOR_powderblue MXRGB(176,224,230)
#define MXCOLOR_purple MXRGB(160,32,240)
#define MXCOLOR_purple1 MXRGB(155,48,255)
#define MXCOLOR_purple2 MXRGB(145,44,238)
#define MXCOLOR_purple3 MXRGB(125,38,205)
#define MXCOLOR_purple4 MXRGB(85,26,139)
#define MXCOLOR_red MXRGB(255,0,0)
#define MXCOLOR_red1 MXRGB(255,0,0)
#define MXCOLOR_red2 MXRGB(238,0,0)
#define MXCOLOR_red3 MXRGB(205,0,0)
#define MXCOLOR_red4 MXRGB(139,0,0)
#define MXCOLOR_rosy MXRGB(188,143,143)
#define MXCOLOR_rosybrown MXRGB(188,143,143)
#define MXCOLOR_rosybrown1 MXRGB(255,193,193)
#define MXCOLOR_rosybrown2 MXRGB(238,180,180)
#define MXCOLOR_rosybrown3 MXRGB(205,155,155)
#define MXCOLOR_rosybrown4 MXRGB(139,105,105)
#define MXCOLOR_royal MXRGB(65,105,225)
#define MXCOLOR_royalblue MXRGB(65,105,225)
#define MXCOLOR_royalblue1 MXRGB(72,118,255)
#define MXCOLOR_royalblue2 MXRGB(67,110,238)
#define MXCOLOR_royalblue3 MXRGB(58,95,205)
#define MXCOLOR_royalblue4 MXRGB(39,64,139)
#define MXCOLOR_saddle MXRGB(139,69,19)
#define MXCOLOR_saddlebrown MXRGB(139,69,19)
#define MXCOLOR_salmon MXRGB(233,150,122)
#define MXCOLOR_salmon1 MXRGB(255,140,105)
#define MXCOLOR_salmon2 MXRGB(238,130,98)
#define MXCOLOR_salmon3 MXRGB(205,112,84)
#define MXCOLOR_salmon4 MXRGB(139,76,57)
#define MXCOLOR_sandy MXRGB(244,164,96)
#define MXCOLOR_sandybrown MXRGB(244,164,96)
#define MXCOLOR_sea MXRGB(82,149,132)
#define MXCOLOR_seagreen MXRGB(82,149,132)
#define MXCOLOR_seagreen1 MXRGB(84,255,159)
#define MXCOLOR_seagreen2 MXRGB(78,238,148)
#define MXCOLOR_seagreen3 MXRGB(67,205,128)
#define MXCOLOR_seagreen4 MXRGB(46,139,87)
#define MXCOLOR_seashell MXRGB(255,245,238)
#define MXCOLOR_seashell1 MXRGB(255,245,238)
#define MXCOLOR_seashell2 MXRGB(238,229,222)
#define MXCOLOR_seashell3 MXRGB(205,197,191)
#define MXCOLOR_seashell4 MXRGB(139,134,130)
#define MXCOLOR_sienna MXRGB(150,82,45)
#define MXCOLOR_sienna1 MXRGB(255,130,71)
#define MXCOLOR_sienna2 MXRGB(238,121,66)
#define MXCOLOR_sienna3 MXRGB(205,104,57)
#define MXCOLOR_sienna4 MXRGB(139,71,38)
#define MXCOLOR_sky MXRGB(114,159,255)
#define MXCOLOR_skyblue MXRGB(114,159,255)
#define MXCOLOR_skyblue1 MXRGB(135,206,255)
#define MXCOLOR_skyblue2 MXRGB(126,192,238)
#define MXCOLOR_skyblue3 MXRGB(108,166,205)
#define MXCOLOR_skyblue4 MXRGB(74,112,139)
#define MXCOLOR_slate MXRGB(126,136,171)
#define MXCOLOR_slateblue MXRGB(126,136,171)
#define MXCOLOR_slateblue1 MXRGB(131,111,255)
#define MXCOLOR_slateblue2 MXRGB(122,103,238)
#define MXCOLOR_slateblue3 MXRGB(105,89,205)
#define MXCOLOR_slateblue4 MXRGB(71,60,139)
#define MXCOLOR_slategray MXRGB(112,128,144)
#define MXCOLOR_slategray1 MXRGB(198,226,255)
#define MXCOLOR_slategray2 MXRGB(185,211,238)
#define MXCOLOR_slategray3 MXRGB(159,182,205)
#define MXCOLOR_slategray4 MXRGB(108,123,139)
#define MXCOLOR_slategrey MXRGB(112,128,144)
#define MXCOLOR_snow MXRGB(255,250,250)
#define MXCOLOR_snow1 MXRGB(255,250,250)
#define MXCOLOR_snow2 MXRGB(238,233,233)
#define MXCOLOR_snow3 MXRGB(205,201,201)
#define MXCOLOR_snow4 MXRGB(139,137,137)
#define MXCOLOR_spring MXRGB(65,172,65)
#define MXCOLOR_springgreen MXRGB(65,172,65)
#define MXCOLOR_springgreen1 MXRGB(0,255,127)
#define MXCOLOR_springgreen2 MXRGB(0,238,118)
#define MXCOLOR_springgreen3 MXRGB(0,205,102)
#define MXCOLOR_springgreen4 MXRGB(0,139,69)
#define MXCOLOR_steel MXRGB(84,112,170)
#define MXCOLOR_steelblue MXRGB(84,112,170)
#define MXCOLOR_steelblue1 MXRGB(99,184,255)
#define MXCOLOR_steelblue2 MXRGB(92,172,238)
#define MXCOLOR_steelblue3 MXRGB(79,148,205)
#define MXCOLOR_steelblue4 MXRGB(54,100,139)
#define MXCOLOR_tan MXRGB(222,184,135)
#define MXCOLOR_tan1 MXRGB(255,165,79)
#define MXCOLOR_tan2 MXRGB(238,154,73)
#define MXCOLOR_tan3 MXRGB(205,133,63)
#define MXCOLOR_tan4 MXRGB(139,90,43)
#define MXCOLOR_thistle MXRGB(216,191,216)
#define MXCOLOR_thistle1 MXRGB(255,225,255)
#define MXCOLOR_thistle2 MXRGB(238,210,238)
#define MXCOLOR_thistle3 MXRGB(205,181,205)
#define MXCOLOR_thistle4 MXRGB(139,123,139)
#define MXCOLOR_tomato MXRGB(255,99,71)
#define MXCOLOR_tomato1 MXRGB(255,99,71)
#define MXCOLOR_tomato2 MXRGB(238,92,66)
#define MXCOLOR_tomato3 MXRGB(205,79,57)
#define MXCOLOR_tomato4 MXRGB(139,54,38)
#define MXCOLOR_transparent MXRGBT(0,0,0,0xFF)
#define MXCOLOR_turquoise MXRGB(25,204,223)
#define MXCOLOR_turquoise1 MXRGB(0,245,255)
#define MXCOLOR_turquoise2 MXRGB(0,229,238)
#define MXCOLOR_turquoise3 MXRGB(0,197,205)
#define MXCOLOR_turquoise4 MXRGB(0,134,139)
#define MXCOLOR_violet MXRGB(156,62,206)
#define MXCOLOR_violetred MXRGB(243,62,150)
#define MXCOLOR_violetred1 MXRGB(255,62,150)
#define MXCOLOR_violetred2 MXRGB(238,58,140)
#define MXCOLOR_violetred3 MXRGB(205,50,120)
#define MXCOLOR_violetred4 MXRGB(139,34,82)
#define MXCOLOR_wheat MXRGB(245,222,179)
#define MXCOLOR_wheat1 MXRGB(255,231,186)
#define MXCOLOR_wheat2 MXRGB(238,216,174)
#define MXCOLOR_wheat3 MXRGB(205,186,150)
#define MXCOLOR_wheat4 MXRGB(139,126,102)
#define MXCOLOR_white MXRGB(255,255,255)
#define MXCOLOR_whitesmoke MXRGB(245,245,245)
#define MXCOLOR_yellow MXRGB(255,255,0)
#define MXCOLOR_yellow1 MXRGB(255,255,0)
#define MXCOLOR_yellow2 MXRGB(238,238,0)
#define MXCOLOR_yellow3 MXRGB(205,205,0)
#define MXCOLOR_yellow4 MXRGB(139,139,0)
#define MXCOLOR_yellowgreen MXRGB(50,216,56)

#endif
