#include "degfx/bitmap.h"
#include <assert.h>

#define MX__CLIP_VLINE(rect, xa, ya, yb)                                       \
   (((xa) < (rect).x1) ||                                                    \
    ((xa) > (rect).x2) ||                                                    \
    (((yb) = MX_MIN((yb), ((rect).y2))) < ((ya) = MX_MAX((ya), ((rect).y1)))))

void mx_bitmap_vline(MX_BITMAP * bitmap, int x1, int y1, int y2, MX_PIXEL color)
{
	MX_PIXEL *start;
	const MX_RECT *area;
	const unsigned int trans = MXT(color);
	int count;

	if (MX__CLIP_VLINE(bitmap->_clip, x1, y1, y2))
		return;

	if (trans == 0xFF)
		return;

	area = MXRECT(bitmap);
	assert(x1 >= area->x1);
	assert(y1 >= area->y1);
	assert(y2 >= area->y1);
	assert(x1 <= area->x2);
	assert(y1 <= area->y2);
	assert(y2 <= area->y2);

	y1 -= area->y1;
	y2 -= area->y1;
	start = &bitmap->_array[y1 * bitmap->_pitch + (x1 - area->x1)];
	count = y2 - y1 + 1;

	if (trans) {
		while (count--) {
			*start = MXBLENDT(color, *start, trans);
			start += bitmap->_pitch;
			++y1;
		}
	} else {
		while (count--) {
			*start = color;
			start += bitmap->_pitch;
			++y1;
		}
	}
}
