#include "degfx/bitmap.h"
#include <assert.h>

void mx_bitmap_blittrans(const MX_BITMAP * src, MX_BITMAP * dest, int sx, int sy, int dx, int dy, int w, int h, unsigned long trans)
{
	int x, y;
	MX_BITMAP_ITER srci, dsti;
	const MX_RECT *srcarea = MXRECT(src);

	/* Fast handling of certian transparency values */
	if (trans == 0xff) {
		return;

	} else if (trans == 0) {
		mx_bitmap_blit(src, dest, sx, sy, dx, dy, w, h);
		return;
	}

	/** The w and h parameters may be MXDEFAULT and the width of the source
    bitmap will be used. */
	if (w == MXDEFAULT)
		w = mx_w(src);
	if (h == MXDEFAULT)
		h = mx_h(src);

	/** The current implementation requires that the source and destination
        bitmaps not refer to the same bitmap. */
	assert(src != dest);
	MX__CLIP_BLIT(*srcarea, dest->_clip, sx, sy, dx, dy, w, h);

	for (y = 0; y <= h; y++) {

		srci = mx_bitmap_iter(src, sx, sy + y);
		dsti = mx_bitmap_iter(dest, dx, dy + y);

		for (x = 0; x <= w; x++) {
			*dsti = MXBLENDT(*srci, *dsti, trans);
			++dsti;
			++srci;
		}
	}
}
