#include "degfx/bitmap.h"
#include <assert.h>

#define MX__CLIP_RECT(rect, x1, y1, x2, y2)                                      \
   ((((x2) = MX_MIN((x2), ((rect).x2))) < ((x1) = MX_MAX((x1), ((rect).x1)))) || \
    (((y2) = MX_MIN((y2), ((rect).y2))) < ((y1) = MX_MAX((y1), ((rect).y1)))))

void mx_bitmap_rectfill(MX_BITMAP * bitmap, int x1, int y1, int x2, int y2, MX_PIXEL color)
{
#ifdef MXDEBUG
	const MX_RECT *area;
#endif

	if (MX__CLIP_RECT(bitmap->_clip, x1, y1, x2, y2))
		return;

#ifdef MXDEBUG
	area = MXRECT(bitmap);
	assert(x1 >= area->x1);
	assert(y1 >= area->y1);
	assert(x2 >= area->x1);
	assert(x1 <= area->x2);
	assert(y1 <= area->y2);
	assert(x2 <= area->x2);
#endif

	/** The current implementation uses horizontal lines to fill the rectangle. */
	while (y1 <= y2) {
		mx__fasthline(bitmap, x1, y1, x2, color);
		++y1;
	}
}
