#include "degfx/bitmap.h"
#include <assert.h>

void mx_bitmap_pixel(MX_BITMAP * bitmap, int x1, int y1, MX_PIXEL color)
{
	/** If the specified coordinates are outside the area of the bitmap then
    this function does nothing. */
	if (MX__CLIP_PIXEL(bitmap->_clip, x1, y1))
		return;

	else {
		const MX_RECT *area = MXRECT(bitmap);
		MX_PIXEL *pixel = &bitmap->_array[(y1 - area->y1) * bitmap->_pitch + (x1 - area->x1)];

		assert(x1 >= area->x1);
		assert(y1 >= area->y1);
		assert(x1 <= area->x2);
		assert(y1 <= area->y2);

		*pixel = MXBLEND(color, *pixel);
	}
}
