#include "degfx/bitmap.h"

MX_BITMAP_ITER mx_bitmap_iter(const MX_BITMAP * bitmap, int x1, int y1)
{
	const MX_RECT *area;

	/** If the pixel position is outside the area of the bitmap then 0 is
        returned. */
	if (MX__CLIP_PIXEL(bitmap->_clip, x1, y1))
		return 0;

	area = MXRECT(bitmap);

	return &bitmap->_array[(y1 - area->y1) * bitmap->_pitch + (x1 - area->x1)];
}

MX_BITMAP_ITER mx_bitmap_begin(const MX_BITMAP * bitmap)
{
	return bitmap->_array;
}

MX_BITMAP_ITER mx_bitmap_end(const MX_BITMAP * bitmap)
{
	return mx_bitmap_iter(bitmap, mx_w(bitmap), mx_h(bitmap)) + 1;
}
