#include "degfx/bitmap.h"
#include <assert.h>

MX_PIXEL mx_bitmap_getpixel(const MX_BITMAP * bitmap, int x1, int y1)
{
	const MX_RECT *area = MXRECT(bitmap);

	/** If the coordinates are outside the bitmap area then 0 is returned. */
	if (MX__CLIP_PIXEL(*area, x1, y1))
		return 0;

	assert(x1 >= area->x1);
	assert(y1 >= area->y1);
	assert(x1 <= area->x2);
	assert(y1 <= area->y2);

	return bitmap->_array[(y1 - area->y1) * bitmap->_pitch + (x1 - area->x1)];
}
