#include "degfx/bitmap.h"

void mx_bitmap_decorate(const MX_BITMAP * src, MX_BITMAP * dest, int x, int y, int x1, int y1, int x2, int y2)
{
	int i, r, b;
	MX_PIXEL c;
	const int w = mx_w(src) + 1;
	const int h = mx_h(src) + 1;

	if (x == MXDEFAULT)
		x = (w + 1) / 2;
	if (y == MXDEFAULT)
		y = (h + 1) / 2;

	r = x2 - w + x;
	b = y2 - h + y;

	/** The corners of the source bitmap are copied as normal. */
	mx_bitmap_blit(src, dest, 0, 0, x1, y1, x - 1, y - 1);
	mx_bitmap_blit(src, dest, x, 0, r + 1, y1, w - x, y - 1);
	mx_bitmap_blit(src, dest, 0, y, x1, b + 1, x - 1, h - y);
	mx_bitmap_blit(src, dest, x, y, r + 1, b + 1, w - x, h - y);

	/* The rest of the desinition bitmap is filled with vertical and
	   horizontal lines and block fills to connect the corners. */
	for (i = 0; i < y - 1; i++) {
		c = mx_bitmap_getpixel(src, x - 1, i);
		mx_bitmap_hline(dest, x1 + x, y1 + i, r, c);
	}

	for (i = y; i < h; i++) {
		c = mx_bitmap_getpixel(src, x - 1, i);
		mx_bitmap_hline(dest, x1 + x, y2 - h + i + 1, r, c);
	}

	for (i = 0; i < x - 1; i++) {
		c = mx_bitmap_getpixel(src, i, y - 1);
		mx_bitmap_vline(dest, x1 + i, y1 + y, b, c);
	}

	for (i = x; i < w; i++) {
		c = mx_bitmap_getpixel(src, i, y - 1);
		mx_bitmap_vline(dest, x2 - w + i + 1, y1 + y, b, c);
	}

	c = mx_bitmap_getpixel(src, x - 1, y - 1);
	mx_bitmap_rectfill(dest, x1 + x - 1, y1 + y - 1, r, b, c);
}
