#include "degfx/bitmap.h"
#include <assert.h>

MX_BITMAP *mx_bitmap_clone(const MX_BITMAP * other)
{
	const int w = mx_w(other);
	const int h = mx_h(other);
	MX_BITMAP *bitmap = mx_bitmap(w, h);

	assert(other);
	assert(bitmap);

	/* The cloned bitmap has the same size and contents as the source. */
	mx_rectatom_place(bitmap, MXRECT(other));

	bitmap->_pitch = other->_pitch;
	bitmap->_clip = other->_clip;

	mx_bitmap_blitcopy(other, bitmap, 0, 0, 0, 0, w, h);

	return bitmap;
}
