#include "degfx/bitmap.h"

#define MX__CLIP_RECT(rect, x1, y1, x2, y2)                                      \
   ((((x2) = MX_MIN((x2), ((rect).x2))) < ((x1) = MX_MAX((x1), ((rect).x1)))) || \
    (((y2) = MX_MIN((y2), ((rect).y2))) < ((y1) = MX_MAX((y1), ((rect).y1)))))

void mx_bitmap_clear(MX_BITMAP * bitmap, MX_PIXEL color)
{
	int x1 = mx_x1(bitmap);
	int y1 = mx_y1(bitmap);
	int x2 = mx_x2(bitmap);
	int y2 = mx_y2(bitmap);

	if (MX__CLIP_RECT(bitmap->_clip, x1, y1, x2, y2))
		return;

	mx_bitmap_rectfill(bitmap, x1, y1, x2, y2, color);
}
