#include "degfx/bitmap.h"

void mx_bitmap_box(MX_BITMAP * bitmap, int x1, int y1, int x2, int y2, int width, MX_PIXEL light, MX_PIXEL dark)
{
	int i;

	if (width < 0) {
		int temp = light;

		light = dark;
		dark = temp;

		width *= -1;
	}

	for (i = 0; i < width; i++) {
		mx_bitmap_vline(bitmap, x1, y1, y2, light);
		mx_bitmap_hline(bitmap, x1 + 1, y1, x2, light);

		mx_bitmap_vline(bitmap, x2, y1 + 1, y2, dark);
		mx_bitmap_hline(bitmap, x1 + 1, y2, x2 - 1, dark);

		x1++, y1++, x2--, y2--;
	}
}
