#include "degfx/bitmap.h"
#include <assert.h>
#include <string.h>

void mx_bitmap_blitcopy(const MX_BITMAP * src, MX_BITMAP * dest, int sx, int sy, int dx, int dy, int w, int h)
{
	int y;
	const MX_RECT *srcarea = MXRECT(src);

	/** The curent implementation requires that the source and destination
        bitmaps be different. */
	assert(src != dest);

	/** If the w or h parameter is set to MXDEFAULT the source bitmap width
        (or height) will be used. */
	if (w == MXDEFAULT)
		w = mx_w(src);
	if (h == MXDEFAULT)
		h = mx_h(src);

	MX__CLIP_BLIT(*srcarea, dest->_clip, sx, sy, dx, dy, w, h);

	for (y = 0; y <= h; y++)
		memcpy(mx_bitmap_iter(dest, dx, dy + y), mx_bitmap_iter(src, sx, sy + y), (w + 1) * sizeof(MX_PIXEL));
}
