#include "degfx/bitmap.h"
#include <assert.h>

void mx_bitmap_blit(const MX_BITMAP * src, MX_BITMAP * dest, int sx, int sy, int dx, int dy, int w, int h)
{
	int y;

	/* This is not necessary because the w and h are clipped to the source rect in the MX__CLIP_BLIT macro anyway. */

/** If the w or h parameter is set to MXDEFAULT the source bitmap width
        (or height) will be used. */
	if (w == MXDEFAULT)
		w = mx_w(src);
	if (h == MXDEFAULT)
		h = mx_h(src);

/** The curent implementation requires that the source and destination bitmaps be different. */
	assert(src != dest);

	MX__CLIP_BLIT(*MXRECT(src), dest->_clip, sx, sy, dx, dy, w, h);

	/** If either of the w or h parameters is less than zer this function does nothing. */
	if ((h < 0) || (w < 0))
		return;

	for (y = 0; y <= h; y++) {
		MX_BITMAP_ITER srci = mx_bitmap_iter(src, sx, sy + y);
		MX_BITMAP_ITER dsti = mx_bitmap_iter(dest, dx, dy + y);
		const MX_BITMAP_ITER endi = dsti + w + 1;

		while (dsti != endi) {
	/** The transparency is handeled per pixel and the source determines
            the transparency. */
			*dsti = MXBLEND(*srci, *dsti);
			++dsti;
			++srci;
		}
	}
}
