#include "degfx/bitmap.h"
#include <assert.h>

static void mx__bitmap_destroy(void *atom)
{
	MX_BITMAP *bitmap = (MX_BITMAP *) atom;

	mx_free(bitmap->_array);
}

MX_BITMAP *mx_bitmap(int x2, int y2)
{
/** Bitmap is derived from MX_ATOM so it must be destroyed with mx_delete(). */
	MX_RECT area;
	MX_BITMAP *bitmap = mx_rectatom((MX_RECTATOM *) 0, mx__bitmap_destroy,
									sizeof(MX_BITMAP));

	MXDEBUG_ATOMNAME(bitmap, "bitmap");
	MXDEBUG_ALLOCTAG(bitmap);

	area.x1 = 0;
	area.y1 = 0;
	area.x2 = x2;
	area.y2 = y2;
	mx_rectatom_place(bitmap, &area);

	bitmap->_pitch = x2 + 1;
	bitmap->_clip = *MXRECT(bitmap);
	bitmap->_array = (MX_PIXEL *) mx_malloc((x2 + 1) * (y2 + 1) * sizeof(MX_PIXEL));
	assert(bitmap->_array);
	MXDEBUG_ALLOCTAG(bitmap->_array);

	return bitmap;
}
