#include "deds/vector.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>

size_t mx__vector_makeroom(MX__VECTOR_DATA * vect, const size_t num, const size_t place, const size_t sizeofdata)
{
	const size_t size = vect->_size + num;
	const size_t dindex = (place < vect->_size) ? (place) : (vect->_size);
	const size_t offset = dindex * sizeofdata;
	const size_t databytes = num * sizeofdata;

	assert(vect);
	assert(sizeofdata);

		/**todo During appending we expand vectors by doubling thier size with a
        minimum of 16 but a different value might be better in some applications.
        Can a reasonable API be made for this? */
	if (size > vect->_capacity) {
		const int newcapacity = (size < 16) ? (16) : (2 * size);

		mx__vector_reserve(vect, newcapacity, sizeofdata);
	}

	if ((databytes) && (vect->_size * sizeofdata - offset > 0)) {
		unsigned char *ret = (unsigned char *) (vect->_data) + offset;

		memmove(ret + databytes, ret, vect->_size * sizeofdata - offset);
	}
	vect->_size = size;
	return dindex;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
