#include "deds/string.h"
#include <assert.h>

/** !Get MX_STRING text and length
This function return the text of the string along with the length
of the text segment. */
const char *mx_string_text(const MX_STRING * string, int *len)
{
	assert(string);

	/** The len argument can be 0 in which case the length is not returned. */
	if (len)
		*len = string->_len;

	return string->_text;
}

/** !Get MX_STRING length
This function return the length of the text segment. */
int mx_string_len(const MX_STRING * string)
{
	assert(string);

	return string->_len;
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
